/*
 * Decompiled with CFR 0.152.
 */
package androidx.renderscript;

import android.os.Build;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.FieldPacker;
import androidx.renderscript.RSIllegalArgumentException;
import androidx.renderscript.RenderScript;
import androidx.renderscript.Script;
import androidx.renderscript.ScriptIntrinsic;

public class ScriptIntrinsicConvolve3x3
extends ScriptIntrinsic {
    private final float[] mValues = new float[9];
    private Allocation mInput;
    private static final int INTRINSIC_API_LEVEL = 19;

    ScriptIntrinsicConvolve3x3(long id, RenderScript rs) {
        super(id, rs);
    }

    public static ScriptIntrinsicConvolve3x3 create(RenderScript rs, Element e) {
        float[] f = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        if (!(e.isCompatible(Element.U8(rs)) || e.isCompatible(Element.U8_2(rs)) || e.isCompatible(Element.U8_3(rs)) || e.isCompatible(Element.U8_4(rs)) || e.isCompatible(Element.F32(rs)) || e.isCompatible(Element.F32_2(rs)) || e.isCompatible(Element.F32_3(rs)) || e.isCompatible(Element.F32_4(rs)))) {
            throw new RSIllegalArgumentException("Unsupported element type.");
        }
        boolean mUseIncSupp = rs.isUseNative() && Build.VERSION.SDK_INT < 19;
        long id = rs.nScriptIntrinsicCreate(1, e.getID(rs), mUseIncSupp);
        ScriptIntrinsicConvolve3x3 si = new ScriptIntrinsicConvolve3x3(id, rs);
        si.setIncSupp(mUseIncSupp);
        si.setCoefficients(f);
        return si;
    }

    public void setInput(Allocation ain) {
        this.mInput = ain;
        this.setVar(1, ain);
    }

    public void setCoefficients(float[] v) {
        FieldPacker fp = new FieldPacker(36);
        for (int ct = 0; ct < this.mValues.length; ++ct) {
            this.mValues[ct] = v[ct];
            fp.addF32(this.mValues[ct]);
        }
        this.setVar(0, fp);
    }

    public void forEach(Allocation aout) {
        this.forEach(0, (Allocation)null, aout, null);
    }

    public void forEach(Allocation aout, Script.LaunchOptions opt) {
        this.forEach(0, (Allocation)null, aout, null, opt);
    }

    public Script.KernelID getKernelID() {
        return this.createKernelID(0, 2, null, null);
    }

    public Script.FieldID getFieldID_Input() {
        return this.createFieldID(1, null);
    }
}

