
Android TextSwitcher Sample
===================================

This sample illustrates the use of a TextSwitcher to display animations for text changes.

Introduction
------------

This sample shows the use of the [android.widget.TextSwitcher][1] View with animations. A
TextSwitcher is a special type of [android.widget.ViewSwitcher][2] that animates
the current text out and new text in when
[android.widget.TextSwitcher#setText(CharSequence)][3] is called.

Click the "Next" button to set new text in the TextSwitcher and observe the
in and out fade animations.

[1]: http://developer.android.com/reference/android/widget/TextSwitcher.html
[2]: http://developer.android.com/reference/android/widget/ViewSwitcher.html
[3]: http://developer.android.com/reference/android/widget/TextSwitcher.html#setText(java.lang.CharSequence)

Pre-requisites
--------------

- Android SDK 27
- Android Build Tools v27.0.2
- Android Support Repository

Screenshots
-------------

<img src="screenshots/main.png" height="400" alt="Screenshot"/> 

Getting Started
---------------

This sample uses the Gradle build system. To build this project, use the
"gradlew build" command or use "Import Project" in Android Studio.

Support
-------

- Google+ Community: https://plus.google.com/communities/105153134372062985968
- Stack Overflow: http://stackoverflow.com/questions/tagged/android

If you've found an error in this sample, please file an issue:
https://github.com/googlesamples/android-TextSwitcher

Patches are encouraged, and may be submitted by forking this project and
submitting a pull request through GitHub. Please see CONTRIBUTING.md for more details.

License
-------

Copyright 2017 The Android Open Source Project, Inc.

Licensed to the Apache Software Foundation (ASF) under one or more contributor
license agreements.  See the NOTICE file distributed with this work for
additional information regarding copyright ownership.  The ASF licenses this
file to you under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License.  You may obtain a copy of
the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
License for the specific language governing permissions and limitations under
the License.
