
Android ActionBarCompat-Styled Sample
===================================

This sample shows you how to use ActionBarCompat with a customized theme. It utilizes a
split action bar when running on a device with a narrow display, and shows three tabs.

Introduction
------------

This sample shows how to style an ActionBar using the [support library][1] on devices running
Android v2.1+ using a custom theme.

This Activity extends from AppCompatActivity, which provides all of the function
necessary to display a compatible Action Bar on devices running Android v2.1+.
A custom application theme and styles are defined in XML.

Assets have been generated using the ['Android Action Bar Style Generator'][2].

[1]: http://developer.android.com/tools/support-library/
[2]: http://jgilfelt.github.io/android-actionbarstylegenerator

Pre-requisites
--------------

- Android SDK 27
- Android Build Tools v27.0.2
- Android Support Repository

Screenshots
-------------

<img src="screenshots/1-activity.png" height="400" alt="Screenshot"/> 

Getting Started
---------------

This sample uses the Gradle build system. To build this project, use the
"gradlew build" command or use "Import Project" in Android Studio.

Support
-------

- Google+ Community: https://plus.google.com/communities/105153134372062985968
- Stack Overflow: http://stackoverflow.com/questions/tagged/android

If you've found an error in this sample, please file an issue:
https://github.com/googlesamples/android-ActionBarCompat-Styled

Patches are encouraged, and may be submitted by forking this project and
submitting a pull request through GitHub. Please see CONTRIBUTING.md for more details.

License
-------

Copyright 2017 The Android Open Source Project, Inc.

Licensed to the Apache Software Foundation (ASF) under one or more contributor
license agreements.  See the NOTICE file distributed with this work for
additional information regarding copyright ownership.  The ASF licenses this
file to you under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License.  You may obtain a copy of
the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
License for the specific language governing permissions and limitations under
the License.
