/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SlidingPaneLayout
extends ViewGroup {
    private static final String TAG = "SlidingPaneLayout";
    private static final int DEFAULT_OVERHANG_SIZE = 32;
    private static final int DEFAULT_FADE_COLOR = -858993460;
    private int mSliderFadeColor = -858993460;
    private static final int MIN_FLING_VELOCITY = 400;
    private int mCoveredFadeColor;
    private Drawable mShadowDrawable;
    private final int mOverhangSize;
    private boolean mCanSlide;
    private View mSlideableView;
    private float mSlideOffset;
    private float mParallaxOffset;
    private int mSlideRange;
    private boolean mIsUnableToDrag;
    private int mParallaxBy;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private PanelSlideListener mPanelSlideListener;
    private final ViewDragHelper mDragHelper;
    private boolean mPreservedOpenState;
    private boolean mFirstLayout = true;
    private final Rect mTmpRect = new Rect();
    private final ArrayList<DisableLayerRunnable> mPostedRunnables = new ArrayList();
    static final SlidingPanelLayoutImpl IMPL;

    public SlidingPaneLayout(Context context) {
        this(context, null);
    }

    public SlidingPaneLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingPaneLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float density = context.getResources().getDisplayMetrics().density;
        this.mOverhangSize = (int)(32.0f * density + 0.5f);
        ViewConfiguration viewConfig = ViewConfiguration.get((Context)context);
        this.setWillNotDraw(false);
        ViewCompat.setAccessibilityDelegate((View)this, new AccessibilityDelegate());
        ViewCompat.setImportantForAccessibility((View)this, 1);
        this.mDragHelper = ViewDragHelper.create(this, 0.5f, new DragHelperCallback());
        this.mDragHelper.setEdgeTrackingEnabled(1);
        this.mDragHelper.setMinVelocity(400.0f * density);
    }

    public void setParallaxDistance(int parallaxBy) {
        this.mParallaxBy = parallaxBy;
        this.requestLayout();
    }

    public int getParallaxDistance() {
        return this.mParallaxBy;
    }

    public void setSliderFadeColor(int color) {
        this.mSliderFadeColor = color;
    }

    public int getSliderFadeColor() {
        return this.mSliderFadeColor;
    }

    public void setCoveredFadeColor(int color) {
        this.mCoveredFadeColor = color;
    }

    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public void setPanelSlideListener(PanelSlideListener listener) {
        this.mPanelSlideListener = listener;
    }

    void dispatchOnPanelSlide(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelSlide(panel, this.mSlideOffset);
        }
    }

    void dispatchOnPanelOpened(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelOpened(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelClosed(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelClosed(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void updateObscuredViewsVisibility(View panel) {
        View child;
        int bottom;
        int top;
        int right;
        int left;
        int leftBound = this.getPaddingLeft();
        int rightBound = this.getWidth() - this.getPaddingRight();
        int topBound = this.getPaddingTop();
        int bottomBound = this.getHeight() - this.getPaddingBottom();
        if (panel != null && SlidingPaneLayout.viewIsOpaque(panel)) {
            left = panel.getLeft();
            right = panel.getRight();
            top = panel.getTop();
            bottom = panel.getBottom();
        } else {
            bottom = 0;
            top = 0;
            right = 0;
            left = 0;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount && (child = this.getChildAt(i)) != panel; ++i) {
            int clampedChildLeft = Math.max(leftBound, child.getLeft());
            int clampedChildTop = Math.max(topBound, child.getTop());
            int clampedChildRight = Math.min(rightBound, child.getRight());
            int clampedChildBottom = Math.min(bottomBound, child.getBottom());
            int vis = clampedChildLeft >= left && clampedChildTop >= top && clampedChildRight <= right && clampedChildBottom <= bottom ? 4 : 0;
            child.setVisibility(vis);
        }
    }

    void setAllChildrenVisible() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 4) continue;
            child.setVisibility(0);
        }
    }

    private static boolean viewIsOpaque(View v) {
        if (ViewCompat.isOpaque(v)) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return false;
        }
        Drawable bg = v.getBackground();
        if (bg != null) {
            return bg.getOpacity() == -1;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
        int count = this.mPostedRunnables.size();
        for (int i = 0; i < count; ++i) {
            DisableLayerRunnable dlr = this.mPostedRunnables.get(i);
            dlr.run();
        }
        this.mPostedRunnables.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthAvailable;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0x40000000) {
            if (!this.isInEditMode()) throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
            if (widthMode == Integer.MIN_VALUE) {
                widthMode = 0x40000000;
            } else if (widthMode == 0) {
                widthMode = 0x40000000;
                widthSize = 300;
            }
        } else if (heightMode == 0) {
            if (!this.isInEditMode()) throw new IllegalStateException("Height must not be UNSPECIFIED");
            if (heightMode == 0) {
                heightMode = Integer.MIN_VALUE;
                heightSize = 300;
            }
        }
        int layoutHeight = 0;
        int maxLayoutHeight = -1;
        switch (heightMode) {
            case 0x40000000: {
                layoutHeight = maxLayoutHeight = heightSize - this.getPaddingTop() - this.getPaddingBottom();
                break;
            }
            case -2147483648: {
                maxLayoutHeight = heightSize - this.getPaddingTop() - this.getPaddingBottom();
            }
        }
        float weightSum = 0.0f;
        boolean canSlide = false;
        int widthRemaining = widthAvailable = widthSize - this.getPaddingLeft() - this.getPaddingRight();
        int childCount = this.getChildCount();
        if (childCount > 2) {
            Log.e((String)TAG, (String)"onMeasure: More than two child views are not supported.");
        }
        this.mSlideableView = null;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8) {
                lp.dimWhenOffset = false;
                continue;
            }
            if (lp.weight > 0.0f) {
                weightSum += lp.weight;
                if (lp.width == 0) continue;
            }
            int horizontalMargin = lp.leftMargin + lp.rightMargin;
            int childWidthSpec = lp.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)(widthAvailable - horizontalMargin), (int)Integer.MIN_VALUE) : (lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(widthAvailable - horizontalMargin), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.width, (int)0x40000000));
            int childHeightSpec = lp.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)Integer.MIN_VALUE) : (lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000));
            child.measure(childWidthSpec, childHeightSpec);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (heightMode == Integer.MIN_VALUE && childHeight > layoutHeight) {
                layoutHeight = Math.min(childHeight, maxLayoutHeight);
            }
            lp.slideable = (widthRemaining -= childWidth) < 0;
            canSlide |= lp.slideable;
            if (!lp.slideable) continue;
            this.mSlideableView = child;
        }
        if (canSlide || weightSum > 0.0f) {
            int fixedPanelWidthLimit = widthAvailable - this.mOverhangSize;
            for (int i = 0; i < childCount; ++i) {
                int childWidthSpec;
                int childHeightSpec;
                int measuredWidth;
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (child.getVisibility() == 8) continue;
                boolean skippedFirstPass = lp.width == 0 && lp.weight > 0.0f;
                int n = measuredWidth = skippedFirstPass ? 0 : child.getMeasuredWidth();
                if (canSlide && child != this.mSlideableView) {
                    if (lp.width >= 0 || measuredWidth <= fixedPanelWidthLimit && !(lp.weight > 0.0f)) continue;
                    childHeightSpec = skippedFirstPass ? (lp.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)Integer.MIN_VALUE) : (lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000))) : View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000);
                    int childWidthSpec2 = View.MeasureSpec.makeMeasureSpec((int)fixedPanelWidthLimit, (int)0x40000000);
                    child.measure(childWidthSpec2, childHeightSpec);
                    continue;
                }
                if (!(lp.weight > 0.0f)) continue;
                childHeightSpec = lp.width == 0 ? (lp.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)Integer.MIN_VALUE) : (lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000))) : View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000);
                if (canSlide) {
                    int horizontalMargin = lp.leftMargin + lp.rightMargin;
                    int newWidth = widthAvailable - horizontalMargin;
                    childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
                    if (measuredWidth == newWidth) continue;
                    child.measure(childWidthSpec, childHeightSpec);
                    continue;
                }
                int widthToDistribute = Math.max(0, widthRemaining);
                int addedWidth = (int)(lp.weight * (float)widthToDistribute / weightSum);
                childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)(measuredWidth + addedWidth), (int)0x40000000);
                child.measure(childWidthSpec, childHeightSpec);
            }
        }
        int measuredWidth = widthSize;
        int measuredHeight = layoutHeight + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(measuredWidth, measuredHeight);
        this.mCanSlide = canSlide;
        if (this.mDragHelper.getViewDragState() == 0 || canSlide) return;
        this.mDragHelper.abort();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int i;
        int xStart;
        int width = r - l;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int childCount = this.getChildCount();
        int nextXStart = xStart = paddingLeft;
        if (this.mFirstLayout) {
            this.mSlideOffset = this.mCanSlide && this.mPreservedOpenState ? 1.0f : 0.0f;
        }
        for (i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth();
            int offset = 0;
            if (lp.slideable) {
                int range;
                int margin = lp.leftMargin + lp.rightMargin;
                this.mSlideRange = range = Math.min(nextXStart, width - paddingRight - this.mOverhangSize) - xStart - margin;
                lp.dimWhenOffset = xStart + lp.leftMargin + range + childWidth / 2 > width - paddingRight;
                int pos = (int)((float)range * this.mSlideOffset);
                xStart += pos + lp.leftMargin;
                this.mSlideOffset = (float)pos / (float)this.mSlideRange;
            } else if (this.mCanSlide && this.mParallaxBy != 0) {
                offset = (int)((1.0f - this.mSlideOffset) * (float)this.mParallaxBy);
                xStart = nextXStart;
            } else {
                xStart = nextXStart;
            }
            int childLeft = xStart - offset;
            int childRight = childLeft + childWidth;
            int childTop = paddingTop;
            int childBottom = childTop + child.getMeasuredHeight();
            child.layout(childLeft, paddingTop, childRight, childBottom);
            nextXStart += child.getWidth();
        }
        if (this.mFirstLayout) {
            if (this.mCanSlide) {
                if (this.mParallaxBy != 0) {
                    this.parallaxOtherViews(this.mSlideOffset);
                }
                if (((LayoutParams)this.mSlideableView.getLayoutParams()).dimWhenOffset) {
                    this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
                }
            } else {
                for (i = 0; i < childCount; ++i) {
                    this.dimChildView(this.getChildAt(i), 0.0f, this.mSliderFadeColor);
                }
            }
            this.updateObscuredViewsVisibility(this.mSlideableView);
        }
        this.mFirstLayout = false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.mFirstLayout = true;
        }
    }

    public void requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        if (!this.isInTouchMode() && !this.mCanSlide) {
            this.mPreservedOpenState = child == this.mSlideableView;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        View secondChild;
        int action = MotionEventCompat.getActionMasked(ev);
        if (!this.mCanSlide && action == 0 && this.getChildCount() > 1 && (secondChild = this.getChildAt(1)) != null) {
            boolean bl = this.mPreservedOpenState = !this.mDragHelper.isViewUnder(secondChild, (int)ev.getX(), (int)ev.getY());
        }
        if (!this.mCanSlide || this.mIsUnableToDrag && action != 0) {
            this.mDragHelper.cancel();
            return super.onInterceptTouchEvent(ev);
        }
        if (action == 3 || action == 1) {
            this.mDragHelper.cancel();
            return false;
        }
        boolean interceptTap = false;
        switch (action) {
            case 0: {
                this.mIsUnableToDrag = false;
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                if (!this.mDragHelper.isViewUnder(this.mSlideableView, (int)x, (int)y) || !this.isDimmed(this.mSlideableView)) break;
                interceptTap = true;
                break;
            }
            case 2: {
                float x = ev.getX();
                float y = ev.getY();
                float adx = Math.abs(x - this.mInitialMotionX);
                float ady = Math.abs(y - this.mInitialMotionY);
                int slop = this.mDragHelper.getTouchSlop();
                if (!(adx > (float)slop) || !(ady > adx)) break;
                this.mDragHelper.cancel();
                this.mIsUnableToDrag = true;
                return false;
            }
        }
        boolean interceptForDrag = this.mDragHelper.shouldInterceptTouchEvent(ev);
        return interceptForDrag || interceptTap;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mCanSlide) {
            return super.onTouchEvent(ev);
        }
        this.mDragHelper.processTouchEvent(ev);
        int action = ev.getAction();
        boolean wantTouchEvents = true;
        switch (action & 0xFF) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                break;
            }
            case 1: {
                int slop;
                float y;
                float dy;
                float x;
                float dx;
                if (!this.isDimmed(this.mSlideableView) || !((dx = (x = ev.getX()) - this.mInitialMotionX) * dx + (dy = (y = ev.getY()) - this.mInitialMotionY) * dy < (float)((slop = this.mDragHelper.getTouchSlop()) * slop)) || !this.mDragHelper.isViewUnder(this.mSlideableView, (int)x, (int)y)) break;
                this.closePane(this.mSlideableView, 0);
                break;
            }
        }
        return wantTouchEvents;
    }

    private boolean closePane(View pane, int initialVelocity) {
        if (this.mFirstLayout || this.smoothSlideTo(0.0f, initialVelocity)) {
            this.mPreservedOpenState = false;
            return true;
        }
        return false;
    }

    private boolean openPane(View pane, int initialVelocity) {
        if (this.mFirstLayout || this.smoothSlideTo(1.0f, initialVelocity)) {
            this.mPreservedOpenState = true;
            return true;
        }
        return false;
    }

    @Deprecated
    public void smoothSlideOpen() {
        this.openPane();
    }

    public boolean openPane() {
        return this.openPane(this.mSlideableView, 0);
    }

    @Deprecated
    public void smoothSlideClosed() {
        this.closePane();
    }

    public boolean closePane() {
        return this.closePane(this.mSlideableView, 0);
    }

    public boolean isOpen() {
        return !this.mCanSlide || this.mSlideOffset == 1.0f;
    }

    @Deprecated
    public boolean canSlide() {
        return this.mCanSlide;
    }

    public boolean isSlideable() {
        return this.mCanSlide;
    }

    private void onPanelDragged(int newLeft) {
        if (this.mSlideableView == null) {
            this.mSlideOffset = 0.0f;
            return;
        }
        LayoutParams lp = (LayoutParams)this.mSlideableView.getLayoutParams();
        int leftBound = this.getPaddingLeft() + lp.leftMargin;
        this.mSlideOffset = (float)(newLeft - leftBound) / (float)this.mSlideRange;
        if (this.mParallaxBy != 0) {
            this.parallaxOtherViews(this.mSlideOffset);
        }
        if (lp.dimWhenOffset) {
            this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
        }
        this.dispatchOnPanelSlide(this.mSlideableView);
    }

    private void dimChildView(View v, float mag, int fadeColor) {
        LayoutParams lp = (LayoutParams)v.getLayoutParams();
        if (mag > 0.0f && fadeColor != 0) {
            int baseAlpha = (fadeColor & 0xFF000000) >>> 24;
            int imag = (int)((float)baseAlpha * mag);
            int color = imag << 24 | fadeColor & 0xFFFFFF;
            if (lp.dimPaint == null) {
                lp.dimPaint = new Paint();
            }
            lp.dimPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_OVER));
            if (ViewCompat.getLayerType(v) != 2) {
                ViewCompat.setLayerType(v, 2, lp.dimPaint);
            }
            this.invalidateChildRegion(v);
        } else if (ViewCompat.getLayerType(v) != 0) {
            if (lp.dimPaint != null) {
                lp.dimPaint.setColorFilter(null);
            }
            DisableLayerRunnable dlr = new DisableLayerRunnable(v);
            this.mPostedRunnables.add(dlr);
            ViewCompat.postOnAnimation((View)this, dlr);
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean result;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int save = canvas.save(2);
        if (this.mCanSlide && !lp.slideable && this.mSlideableView != null) {
            canvas.getClipBounds(this.mTmpRect);
            this.mTmpRect.right = Math.min(this.mTmpRect.right, this.mSlideableView.getLeft());
            canvas.clipRect(this.mTmpRect);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            result = super.drawChild(canvas, child, drawingTime);
        } else if (lp.dimWhenOffset && this.mSlideOffset > 0.0f) {
            Bitmap cache;
            if (!child.isDrawingCacheEnabled()) {
                child.setDrawingCacheEnabled(true);
            }
            if ((cache = child.getDrawingCache()) != null) {
                canvas.drawBitmap(cache, (float)child.getLeft(), (float)child.getTop(), lp.dimPaint);
                result = false;
            } else {
                Log.e((String)TAG, (String)("drawChild: child view " + child + " returned null drawing cache"));
                result = super.drawChild(canvas, child, drawingTime);
            }
        } else {
            if (child.isDrawingCacheEnabled()) {
                child.setDrawingCacheEnabled(false);
            }
            result = super.drawChild(canvas, child, drawingTime);
        }
        canvas.restoreToCount(save);
        return result;
    }

    private void invalidateChildRegion(View v) {
        IMPL.invalidateChildRegion(this, v);
    }

    boolean smoothSlideTo(float slideOffset, int velocity) {
        if (!this.mCanSlide) {
            return false;
        }
        LayoutParams lp = (LayoutParams)this.mSlideableView.getLayoutParams();
        int leftBound = this.getPaddingLeft() + lp.leftMargin;
        int x = (int)((float)leftBound + slideOffset * (float)this.mSlideRange);
        if (this.mDragHelper.smoothSlideViewTo(this.mSlideableView, x, this.mSlideableView.getTop())) {
            this.setAllChildrenVisible();
            ViewCompat.postInvalidateOnAnimation((View)this);
            return true;
        }
        return false;
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            if (!this.mCanSlide) {
                this.mDragHelper.abort();
                return;
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setShadowDrawable(Drawable d) {
        this.mShadowDrawable = d;
    }

    public void setShadowResource(int resId) {
        this.setShadowDrawable(this.getResources().getDrawable(resId));
    }

    public void draw(Canvas c) {
        View shadowView;
        super.draw(c);
        View view = shadowView = this.getChildCount() > 1 ? this.getChildAt(1) : null;
        if (shadowView == null || this.mShadowDrawable == null) {
            return;
        }
        int shadowWidth = this.mShadowDrawable.getIntrinsicWidth();
        int right = shadowView.getLeft();
        int top = shadowView.getTop();
        int bottom = shadowView.getBottom();
        int left = right - shadowWidth;
        this.mShadowDrawable.setBounds(left, top, right, bottom);
        this.mShadowDrawable.draw(c);
    }

    private void parallaxOtherViews(float slideOffset) {
        LayoutParams slideLp = (LayoutParams)this.mSlideableView.getLayoutParams();
        boolean dimViews = slideLp.dimWhenOffset && slideLp.leftMargin <= 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            if (v == this.mSlideableView) continue;
            int oldOffset = (int)((1.0f - this.mParallaxOffset) * (float)this.mParallaxBy);
            this.mParallaxOffset = slideOffset;
            int newOffset = (int)((1.0f - slideOffset) * (float)this.mParallaxBy);
            int dx = oldOffset - newOffset;
            v.offsetLeftAndRight(dx);
            if (!dimViews) continue;
            this.dimChildView(v, 1.0f - this.mParallaxOffset, this.mCoveredFadeColor);
        }
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && ViewCompat.canScrollHorizontally(v, -dx);
    }

    boolean isDimmed(View child) {
        if (child == null) {
            return false;
        }
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return this.mCanSlide && lp.dimWhenOffset && this.mSlideOffset > 0.0f;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams ? new LayoutParams((ViewGroup.MarginLayoutParams)p) : new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isOpen = this.isSlideable() ? this.isOpen() : this.mPreservedOpenState;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.isOpen) {
            this.openPane();
        } else {
            this.closePane();
        }
        this.mPreservedOpenState = ss.isOpen;
    }

    static {
        int deviceVersion = Build.VERSION.SDK_INT;
        IMPL = deviceVersion >= 17 ? new SlidingPanelLayoutImplJBMR1() : (deviceVersion >= 16 ? new SlidingPanelLayoutImplJB() : new SlidingPanelLayoutImplBase());
    }

    private class DisableLayerRunnable
    implements Runnable {
        final View mChildView;

        DisableLayerRunnable(View childView) {
            this.mChildView = childView;
        }

        public void run() {
            if (this.mChildView.getParent() == SlidingPaneLayout.this) {
                ViewCompat.setLayerType(this.mChildView, 0, null);
                SlidingPaneLayout.this.invalidateChildRegion(this.mChildView);
            }
            SlidingPaneLayout.this.mPostedRunnables.remove(this);
        }
    }

    class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final Rect mTmpRect = new Rect();

        AccessibilityDelegate() {
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            AccessibilityNodeInfoCompat superNode = AccessibilityNodeInfoCompat.obtain(info);
            super.onInitializeAccessibilityNodeInfo(host, superNode);
            this.copyNodeInfoNoChildren(info, superNode);
            superNode.recycle();
            info.setClassName(SlidingPaneLayout.class.getName());
            info.setSource(host);
            ViewParent parent = ViewCompat.getParentForAccessibility(host);
            if (parent instanceof View) {
                info.setParent((View)parent);
            }
            int childCount = SlidingPaneLayout.this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = SlidingPaneLayout.this.getChildAt(i);
                if (this.filter(child) || child.getVisibility() != 0) continue;
                ViewCompat.setImportantForAccessibility(child, 1);
                info.addChild(child);
            }
        }

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            event.setClassName((CharSequence)SlidingPaneLayout.class.getName());
        }

        public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
            if (!this.filter(child)) {
                return super.onRequestSendAccessibilityEvent(host, child, event);
            }
            return false;
        }

        public boolean filter(View child) {
            return SlidingPaneLayout.this.isDimmed(child);
        }

        private void copyNodeInfoNoChildren(AccessibilityNodeInfoCompat dest, AccessibilityNodeInfoCompat src) {
            Rect rect = this.mTmpRect;
            src.getBoundsInParent(rect);
            dest.setBoundsInParent(rect);
            src.getBoundsInScreen(rect);
            dest.setBoundsInScreen(rect);
            dest.setVisibleToUser(src.isVisibleToUser());
            dest.setPackageName(src.getPackageName());
            dest.setClassName(src.getClassName());
            dest.setContentDescription(src.getContentDescription());
            dest.setEnabled(src.isEnabled());
            dest.setClickable(src.isClickable());
            dest.setFocusable(src.isFocusable());
            dest.setFocused(src.isFocused());
            dest.setAccessibilityFocused(src.isAccessibilityFocused());
            dest.setSelected(src.isSelected());
            dest.setLongClickable(src.isLongClickable());
            dest.addAction(src.getActions());
            dest.setMovementGranularities(src.getMovementGranularities());
        }
    }

    static class SlidingPanelLayoutImplJBMR1
    extends SlidingPanelLayoutImplBase {
        SlidingPanelLayoutImplJBMR1() {
        }

        public void invalidateChildRegion(SlidingPaneLayout parent, View child) {
            ViewCompat.setLayerPaint(child, ((LayoutParams)child.getLayoutParams()).dimPaint);
        }
    }

    static class SlidingPanelLayoutImplJB
    extends SlidingPanelLayoutImplBase {
        private Method mGetDisplayList;
        private Field mRecreateDisplayList;

        SlidingPanelLayoutImplJB() {
            try {
                this.mGetDisplayList = View.class.getDeclaredMethod("getDisplayList", null);
            }
            catch (NoSuchMethodException e) {
                Log.e((String)SlidingPaneLayout.TAG, (String)"Couldn't fetch getDisplayList method; dimming won't work right.", (Throwable)e);
            }
            try {
                this.mRecreateDisplayList = View.class.getDeclaredField("mRecreateDisplayList");
                this.mRecreateDisplayList.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)SlidingPaneLayout.TAG, (String)"Couldn't fetch mRecreateDisplayList field; dimming will be slow.", (Throwable)e);
            }
        }

        public void invalidateChildRegion(SlidingPaneLayout parent, View child) {
            if (this.mGetDisplayList != null && this.mRecreateDisplayList != null) {
                try {
                    this.mRecreateDisplayList.setBoolean(child, true);
                    this.mGetDisplayList.invoke((Object)child, (Object[])null);
                }
                catch (Exception e) {
                    Log.e((String)SlidingPaneLayout.TAG, (String)"Error refreshing display list state", (Throwable)e);
                }
            } else {
                child.invalidate();
                return;
            }
            super.invalidateChildRegion(parent, child);
        }
    }

    static class SlidingPanelLayoutImplBase
    implements SlidingPanelLayoutImpl {
        SlidingPanelLayoutImplBase() {
        }

        public void invalidateChildRegion(SlidingPaneLayout parent, View child) {
            ViewCompat.postInvalidateOnAnimation((View)parent, child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        }
    }

    static interface SlidingPanelLayoutImpl {
        public void invalidateChildRegion(SlidingPaneLayout var1, View var2);
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean isOpen;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.isOpen = in.readInt() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.isOpen ? 1 : 0);
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int[] ATTRS = new int[]{0x1010181};
        public float weight = 0.0f;
        boolean slideable;
        boolean dimWhenOffset;
        Paint dimPaint;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.weight = source.weight;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, ATTRS);
            this.weight = a.getFloat(0, 0.0f);
            a.recycle();
        }
    }

    private class DragHelperCallback
    extends ViewDragHelper.Callback {
        private DragHelperCallback() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            if (SlidingPaneLayout.this.mIsUnableToDrag) {
                return false;
            }
            return ((LayoutParams)child.getLayoutParams()).slideable;
        }

        public void onViewDragStateChanged(int state) {
            if (SlidingPaneLayout.this.mDragHelper.getViewDragState() == 0) {
                if (SlidingPaneLayout.this.mSlideOffset == 0.0f) {
                    SlidingPaneLayout.this.updateObscuredViewsVisibility(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.this.dispatchOnPanelClosed(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.this.mPreservedOpenState = false;
                } else {
                    SlidingPaneLayout.this.dispatchOnPanelOpened(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.this.mPreservedOpenState = true;
                }
            }
        }

        public void onViewCaptured(View capturedChild, int activePointerId) {
            SlidingPaneLayout.this.setAllChildrenVisible();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            SlidingPaneLayout.this.onPanelDragged(left);
            SlidingPaneLayout.this.invalidate();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            LayoutParams lp = (LayoutParams)releasedChild.getLayoutParams();
            int left = SlidingPaneLayout.this.getPaddingLeft() + lp.leftMargin;
            if (xvel > 0.0f || xvel == 0.0f && SlidingPaneLayout.this.mSlideOffset > 0.5f) {
                left += SlidingPaneLayout.this.mSlideRange;
            }
            SlidingPaneLayout.this.mDragHelper.settleCapturedViewAt(left, releasedChild.getTop());
            SlidingPaneLayout.this.invalidate();
        }

        public int getViewHorizontalDragRange(View child) {
            return SlidingPaneLayout.this.mSlideRange;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            LayoutParams lp = (LayoutParams)SlidingPaneLayout.this.mSlideableView.getLayoutParams();
            int leftBound = SlidingPaneLayout.this.getPaddingLeft() + lp.leftMargin;
            int rightBound = leftBound + SlidingPaneLayout.this.mSlideRange;
            int newLeft = Math.min(Math.max(left, leftBound), rightBound);
            return newLeft;
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return child.getTop();
        }

        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            SlidingPaneLayout.this.mDragHelper.captureChildView(SlidingPaneLayout.this.mSlideableView, pointerId);
        }
    }

    public static class SimplePanelSlideListener
    implements PanelSlideListener {
        public void onPanelSlide(View panel, float slideOffset) {
        }

        public void onPanelOpened(View panel) {
        }

        public void onPanelClosed(View panel) {
        }
    }

    public static interface PanelSlideListener {
        public void onPanelSlide(View var1, float var2);

        public void onPanelOpened(View var1);

        public void onPanelClosed(View var1);
    }
}

