/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.ManifestParser;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CancellationException;

public class ManifestFetcher<T>
implements Loader.Callback {
    final ManifestParser<T> parser;
    final String contentId;
    final String userAgent;
    private final Handler eventHandler;
    private final EventListener eventListener;
    volatile String manifestUrl;
    private int enabledCount;
    private Loader loader;
    private ManifestLoadable currentLoadable;
    private int loadExceptionCount;
    private long loadExceptionTimestamp;
    private IOException loadException;
    private volatile T manifest;
    private volatile long manifestLoadTimestamp;

    public ManifestFetcher(ManifestParser<T> parser, String contentId, String manifestUrl, String userAgent) {
        this(parser, contentId, manifestUrl, userAgent, null, null);
    }

    public ManifestFetcher(ManifestParser<T> parser, String contentId, String manifestUrl, String userAgent, Handler eventHandler, EventListener eventListener) {
        this.parser = parser;
        this.contentId = contentId;
        this.manifestUrl = manifestUrl;
        this.userAgent = userAgent;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
    }

    public void updateManifestUrl(String manifestUrl) {
        this.manifestUrl = manifestUrl;
    }

    public void singleLoad(Looper callbackLooper, ManifestCallback<T> callback) {
        SingleFetchHelper fetchHelper = new SingleFetchHelper(callbackLooper, callback);
        fetchHelper.startLoading();
    }

    public T getManifest() {
        return this.manifest;
    }

    public long getManifestLoadTimestamp() {
        return this.manifestLoadTimestamp;
    }

    public IOException getError() {
        if (this.loadExceptionCount <= 1) {
            return null;
        }
        return this.loadException;
    }

    public void enable() {
        if (this.enabledCount++ == 0) {
            this.loadExceptionCount = 0;
            this.loadException = null;
        }
    }

    public void disable() {
        if (--this.enabledCount == 0 && this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
    }

    public void requestRefresh() {
        if (this.loadException != null && SystemClock.elapsedRealtime() < this.loadExceptionTimestamp + this.getRetryDelayMillis(this.loadExceptionCount)) {
            return;
        }
        if (this.loader == null) {
            this.loader = new Loader("manifestLoader");
        }
        if (!this.loader.isLoading()) {
            this.currentLoadable = new ManifestLoadable();
            this.loader.startLoading(this.currentLoadable, this);
            this.notifyManifestRefreshStarted();
        }
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        if (this.currentLoadable != loadable) {
            return;
        }
        this.manifest = this.currentLoadable.result;
        this.manifestLoadTimestamp = SystemClock.elapsedRealtime();
        this.loadExceptionCount = 0;
        this.loadException = null;
        this.notifyManifestRefreshed();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException exception) {
        if (this.currentLoadable != loadable) {
            return;
        }
        ++this.loadExceptionCount;
        this.loadExceptionTimestamp = SystemClock.elapsedRealtime();
        this.loadException = new IOException(exception);
        this.notifyManifestError(this.loadException);
    }

    private long getRetryDelayMillis(long errorCount) {
        return Math.min((errorCount - 1L) * 1000L, 5000L);
    }

    private void notifyManifestRefreshStarted() {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ManifestFetcher.this.eventListener.onManifestRefreshStarted();
                }
            });
        }
    }

    private void notifyManifestRefreshed() {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ManifestFetcher.this.eventListener.onManifestRefreshed();
                }
            });
        }
    }

    private void notifyManifestError(final IOException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ManifestFetcher.this.eventListener.onManifestError(e);
                }
            });
        }
    }

    private class ManifestLoadable
    implements Loader.Loadable {
        private static final int TIMEOUT_MILLIS = 10000;
        volatile T result;
        private volatile boolean isCanceled;

        private ManifestLoadable() {
        }

        @Override
        public void cancelLoad() {
            this.isCanceled = true;
        }

        @Override
        public boolean isLoadCanceled() {
            return this.isCanceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load() throws IOException, InterruptedException {
            try (InputStream inputStream = null;){
                URLConnection connection = this.configureConnection(new URL(ManifestFetcher.this.manifestUrl));
                inputStream = connection.getInputStream();
                String inputEncoding = connection.getContentEncoding();
                this.result = ManifestFetcher.this.parser.parse(inputStream, inputEncoding, ManifestFetcher.this.contentId, Util.parseBaseUri(connection.getURL().toString()));
            }
        }

        private URLConnection configureConnection(URL url) throws IOException {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(false);
            connection.setRequestProperty("User-Agent", ManifestFetcher.this.userAgent);
            connection.connect();
            return connection;
        }
    }

    private class SingleFetchHelper
    implements Loader.Callback {
        private final Looper callbackLooper;
        private final ManifestCallback<T> wrappedCallback;
        private final Loader singleUseLoader;
        private final ManifestLoadable singleUseLoadable;

        public SingleFetchHelper(Looper callbackLooper, ManifestCallback<T> wrappedCallback) {
            this.callbackLooper = callbackLooper;
            this.wrappedCallback = wrappedCallback;
            this.singleUseLoader = new Loader("manifestLoader:single");
            this.singleUseLoadable = new ManifestLoadable();
        }

        public void startLoading() {
            this.singleUseLoader.startLoading(this.callbackLooper, this.singleUseLoadable, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadCompleted(Loader.Loadable loadable) {
            try {
                ManifestFetcher.this.manifest = this.singleUseLoadable.result;
                ManifestFetcher.this.manifestLoadTimestamp = SystemClock.elapsedRealtime();
                this.wrappedCallback.onManifest(ManifestFetcher.this.contentId, this.singleUseLoadable.result);
            }
            finally {
                this.releaseLoader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadCanceled(Loader.Loadable loadable) {
            try {
                IOException exception = new IOException("Load cancelled", new CancellationException());
                this.wrappedCallback.onManifestError(ManifestFetcher.this.contentId, exception);
            }
            finally {
                this.releaseLoader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadError(Loader.Loadable loadable, IOException exception) {
            try {
                this.wrappedCallback.onManifestError(ManifestFetcher.this.contentId, exception);
            }
            finally {
                this.releaseLoader();
            }
        }

        private void releaseLoader() {
            this.singleUseLoader.release();
        }
    }

    public static interface ManifestCallback<T> {
        public void onManifest(String var1, T var2);

        public void onManifestError(String var1, IOException var2);
    }

    public static interface EventListener {
        public void onManifestRefreshStarted();

        public void onManifestRefreshed();

        public void onManifestError(IOException var1);
    }
}

