/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.annotation.SuppressLint;
import android.util.Pair;
import com.google.android.exoplayer.util.Assertions;
import java.util.ArrayList;

public final class CodecSpecificDataUtil {
    private static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};
    private static final int[] AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    private static final int[] AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE = new int[]{0, 1, 2, 3, 4, 5, 6, 8};
    private static final int SPS_NAL_UNIT_TYPE = 7;

    private CodecSpecificDataUtil() {
    }

    public static Pair<Integer, Integer> parseAudioSpecificConfig(byte[] audioSpecificConfig) {
        int audioObjectType = audioSpecificConfig[0] >> 3 & 0x1F;
        int byteOffset = audioObjectType == 5 || audioObjectType == 29 ? 1 : 0;
        int frequencyIndex = (audioSpecificConfig[byteOffset] & 7) << 1 | audioSpecificConfig[byteOffset + 1] >> 7 & 1;
        Assertions.checkState(frequencyIndex < 13);
        int sampleRate = AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[frequencyIndex];
        int channelCount = audioSpecificConfig[byteOffset + 1] >> 3 & 0xF;
        return Pair.create((Object)sampleRate, (Object)channelCount);
    }

    public static byte[] buildAudioSpecificConfig(int audioObjectType, int sampleRateIndex, int channelConfig) {
        byte[] audioSpecificConfig = new byte[]{(byte)(audioObjectType << 3 & 0xF8 | sampleRateIndex >> 1 & 7), (byte)(sampleRateIndex << 7 & 0x80 | channelConfig << 3 & 0x78)};
        return audioSpecificConfig;
    }

    public static byte[] buildAudioSpecificConfig(int sampleRate, int numChannels) {
        int sampleRateIndex = -1;
        for (int i = 0; i < AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE.length; ++i) {
            if (sampleRate != AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[i]) continue;
            sampleRateIndex = i;
        }
        int channelConfig = -1;
        for (int i = 0; i < AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE.length; ++i) {
            if (numChannels != AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE[i]) continue;
            channelConfig = i;
        }
        byte[] csd = new byte[]{(byte)(0x10 | sampleRateIndex >> 1), (byte)((sampleRateIndex & 1) << 7 | channelConfig << 3)};
        return csd;
    }

    public static byte[] buildNalUnit(byte[] data, int offset, int length) {
        byte[] nalUnit = new byte[length + NAL_START_CODE.length];
        System.arraycopy(NAL_START_CODE, 0, nalUnit, 0, NAL_START_CODE.length);
        System.arraycopy(data, offset, nalUnit, NAL_START_CODE.length, length);
        return nalUnit;
    }

    public static byte[][] splitNalUnits(byte[] data) {
        if (!CodecSpecificDataUtil.isNalStartCode(data, 0)) {
            return null;
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int nalUnitIndex = 0;
        do {
            starts.add(nalUnitIndex);
        } while ((nalUnitIndex = CodecSpecificDataUtil.findNalStartCode(data, nalUnitIndex + NAL_START_CODE.length)) != -1);
        byte[][] split = new byte[starts.size()][];
        for (int i = 0; i < starts.size(); ++i) {
            int startIndex = (Integer)starts.get(i);
            int endIndex = i < starts.size() - 1 ? (Integer)starts.get(i + 1) : data.length;
            byte[] nal = new byte[endIndex - startIndex];
            System.arraycopy(data, startIndex, nal, 0, nal.length);
            split[i] = nal;
        }
        return split;
    }

    private static int findNalStartCode(byte[] data, int index) {
        int endIndex = data.length - NAL_START_CODE.length;
        for (int i = index; i <= endIndex; ++i) {
            if (!CodecSpecificDataUtil.isNalStartCode(data, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNalStartCode(byte[] data, int index) {
        if (data.length - index <= NAL_START_CODE.length) {
            return false;
        }
        for (int j = 0; j < NAL_START_CODE.length; ++j) {
            if (data[index + j] == NAL_START_CODE[j]) continue;
            return false;
        }
        return true;
    }

    public static Pair<Integer, Integer> parseSpsNalUnit(byte[] spsNalUnit) {
        if (CodecSpecificDataUtil.isNalStartCode(spsNalUnit, 0) && spsNalUnit.length == 8 && (spsNalUnit[5] & 0x1F) == 7) {
            return Pair.create((Object)CodecSpecificDataUtil.parseAvcProfile(spsNalUnit), (Object)CodecSpecificDataUtil.parseAvcLevel(spsNalUnit));
        }
        return null;
    }

    @SuppressLint(value={"InlinedApi"})
    private static int parseAvcProfile(byte[] data) {
        int profileIdc = data[6] & 0xFF;
        switch (profileIdc) {
            case 66: {
                return 1;
            }
            case 77: {
                return 2;
            }
            case 88: {
                return 4;
            }
            case 100: {
                return 8;
            }
            case 110: {
                return 16;
            }
            case 122: {
                return 32;
            }
            case 244: {
                return 64;
            }
        }
        return 0;
    }

    @SuppressLint(value={"InlinedApi"})
    private static int parseAvcLevel(byte[] data) {
        int levelIdc = data[8] & 0xFF;
        switch (levelIdc) {
            case 9: {
                return 2;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 8;
            }
            case 13: {
                return 16;
            }
            case 20: {
                return 32;
            }
            case 21: {
                return 64;
            }
            case 22: {
                return 128;
            }
            case 30: {
                return 256;
            }
            case 31: {
                return 512;
            }
            case 32: {
                return 1024;
            }
            case 40: {
                return 2048;
            }
            case 41: {
                return 4096;
            }
            case 42: {
                return 8192;
            }
            case 50: {
                return 16384;
            }
            case 51: {
                return 32768;
            }
        }
        return 0;
    }
}

