/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.FileDataSource;
import com.google.android.exoplayer.upstream.HttpDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public final class UriDataSource
implements DataSource {
    private static final String FILE_URI_SCHEME = "file";
    private final DataSource fileDataSource;
    private final DataSource httpDataSource;
    private DataSource dataSource;

    public UriDataSource(String userAgent, TransferListener transferListener) {
        this(new FileDataSource(transferListener), new HttpDataSource(userAgent, null, transferListener));
    }

    public UriDataSource(DataSource fileDataSource, DataSource httpDataSource) {
        this.fileDataSource = Assertions.checkNotNull(fileDataSource);
        this.httpDataSource = Assertions.checkNotNull(httpDataSource);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        Assertions.checkState(this.dataSource == null);
        this.dataSource = FILE_URI_SCHEME.equals(dataSpec.uri.getScheme()) ? this.fileDataSource : this.httpDataSource;
        return this.dataSource.open(dataSpec);
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws IOException {
        return this.dataSource.read(buffer, offset, readLength);
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
    }
}

