/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.util.Arrays;

public class WebvttSubtitle
implements Subtitle {
    private final String[] cueText;
    private final long startTimeUs;
    private final long[] cueTimesUs;
    private final long[] sortedCueTimesUs;

    public WebvttSubtitle(String[] cueText, long startTimeUs, long[] cueTimesUs) {
        this.cueText = cueText;
        this.startTimeUs = startTimeUs;
        this.cueTimesUs = cueTimesUs;
        this.sortedCueTimesUs = Arrays.copyOf(cueTimesUs, cueTimesUs.length);
        Arrays.sort(this.sortedCueTimesUs);
    }

    @Override
    public long getStartTime() {
        return this.startTimeUs;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        Assertions.checkArgument(timeUs >= 0L);
        int index = Util.binarySearchCeil(this.sortedCueTimesUs, timeUs, false, false);
        return index < this.sortedCueTimesUs.length ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.sortedCueTimesUs.length;
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument(index >= 0);
        Assertions.checkArgument(index < this.sortedCueTimesUs.length);
        return this.sortedCueTimesUs[index];
    }

    @Override
    public long getLastEventTime() {
        if (this.getEventTimeCount() == 0) {
            return -1L;
        }
        return this.sortedCueTimesUs[this.sortedCueTimesUs.length - 1];
    }

    @Override
    public String getText(long timeUs) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.cueTimesUs.length; i += 2) {
            if (this.cueTimesUs[i] > timeUs || timeUs >= this.cueTimesUs[i + 1]) continue;
            stringBuilder.append(this.cueText[i / 2]);
        }
        int stringLength = stringBuilder.length();
        if (stringLength > 0 && stringBuilder.charAt(stringLength - 1) == '\n') {
            --stringLength;
        }
        return stringLength == 0 ? null : stringBuilder.substring(0, stringLength);
    }
}

