/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.webvtt.WebvttSubtitle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebvttParser
implements SubtitleParser {
    public static final String EXO_HEADER = "EXO-HEADER";
    public static final String OFFSET = "OFFSET:";
    private static final long SAMPLING_RATE = 90L;
    private static final String WEBVTT_METADATA_HEADER_STRING = "\\S*[:=]\\S*";
    private static final Pattern WEBVTT_METADATA_HEADER = Pattern.compile("\\S*[:=]\\S*");
    private static final String WEBVTT_TIMESTAMP_STRING = "(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}";
    private static final Pattern WEBVTT_TIMESTAMP = Pattern.compile("(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}");
    private static final Pattern MEDIA_TIMESTAMP_OFFSET = Pattern.compile("OFFSET:\\d+");
    private static final Pattern MEDIA_TIMESTAMP = Pattern.compile("MPEGTS:\\d+");
    private final boolean strictParsing;

    public WebvttParser() {
        this(true);
    }

    public WebvttParser(boolean strictParsing) {
        this.strictParsing = strictParsing;
    }

    @Override
    public WebvttSubtitle parse(InputStream inputStream, String inputEncoding, long startTimeUs) throws IOException {
        Matcher matcher;
        ArrayList<WebvttCue> subtitles = new ArrayList<WebvttCue>();
        long mediaTimestampUs = startTimeUs;
        long mediaTimestampOffsetUs = 0L;
        BufferedReader webvttData = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String line = webvttData.readLine();
        if (line == null) {
            throw new ParserException("Expected WEBVTT or EXO-HEADER. Got null");
        }
        if (line.startsWith(EXO_HEADER)) {
            matcher = MEDIA_TIMESTAMP_OFFSET.matcher(line);
            if (matcher.find()) {
                mediaTimestampOffsetUs = Long.parseLong(matcher.group().substring(7));
            }
            if ((line = webvttData.readLine()) == null) {
                throw new ParserException("Expected WEBVTT. Got null");
            }
        }
        if (!line.equals("WEBVTT")) {
            throw new ParserException("Expected WEBVTT. Got " + line);
        }
        while (true) {
            if ((line = webvttData.readLine()) == null) {
                throw new ParserException("Expected an empty line after webvtt header");
            }
            if (line.isEmpty()) break;
            matcher = WEBVTT_METADATA_HEADER.matcher(line);
            if (!matcher.find()) {
                this.handleNoncompliantLine(line);
            }
            if (!line.startsWith("X-TIMESTAMP-MAP")) continue;
            Matcher timestampMatcher = MEDIA_TIMESTAMP.matcher(line);
            if (!timestampMatcher.find()) {
                throw new ParserException("X-TIMESTAMP-MAP doesn't contain media timestamp: " + line);
            }
            mediaTimestampUs = Long.parseLong(timestampMatcher.group().substring(7)) * 1000L / 90L - mediaTimestampOffsetUs;
            mediaTimestampUs = this.getAdjustedStartTime(mediaTimestampUs);
        }
        while ((line = webvttData.readLine()) != null) {
            matcher = WEBVTT_TIMESTAMP.matcher(line);
            String text = "";
            if (!matcher.find()) {
                throw new ParserException("Expected cue start time: " + line);
            }
            long startTime = WebvttParser.parseTimestampUs(matcher.group()) + mediaTimestampUs;
            if (!matcher.find()) {
                throw new ParserException("Expected cue end time: " + line);
            }
            long endTime = WebvttParser.parseTimestampUs(matcher.group()) + mediaTimestampUs;
            while ((line = webvttData.readLine()) != null && !line.isEmpty()) {
                text = text + line.trim() + "\n";
            }
            WebvttCue cue = new WebvttCue(startTime, endTime, text);
            subtitles.add(cue);
        }
        webvttData.close();
        inputStream.close();
        String[] cueText = new String[subtitles.size()];
        long[] cueTimesUs = new long[2 * subtitles.size()];
        for (int subtitleIndex = 0; subtitleIndex < subtitles.size(); ++subtitleIndex) {
            int arrayIndex = subtitleIndex * 2;
            WebvttCue cue = (WebvttCue)subtitles.get(subtitleIndex);
            cueTimesUs[arrayIndex] = cue.startTime;
            cueTimesUs[arrayIndex + 1] = cue.endTime;
            cueText[subtitleIndex] = cue.text;
        }
        WebvttSubtitle subtitle = new WebvttSubtitle(cueText, mediaTimestampUs, cueTimesUs);
        return subtitle;
    }

    @Override
    public boolean canParse(String mimeType) {
        return "text/vtt".equals(mimeType);
    }

    protected long getAdjustedStartTime(long startTimeUs) {
        return startTimeUs;
    }

    protected void handleNoncompliantLine(String line) throws ParserException {
        if (this.strictParsing) {
            throw new ParserException("Unexpected line: " + line);
        }
    }

    private static long parseTimestampUs(String s) throws NumberFormatException {
        if (!s.matches(WEBVTT_TIMESTAMP_STRING)) {
            throw new NumberFormatException("has invalid format");
        }
        String[] parts = s.split("\\.", 2);
        long value = 0L;
        for (String group : parts[0].split(":")) {
            value = value * 60L + Long.parseLong(group);
        }
        return (value * 1000L + Long.parseLong(parts[1])) * 1000L;
    }

    private static class WebvttCue {
        public final long startTime;
        public final long endTime;
        public final String text;

        public WebvttCue(long startTime, long endTime, String text) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.text = text;
        }
    }
}

