/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.SubtitleParserHelper;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

@TargetApi(value=16)
public class TextTrackRenderer
extends TrackRenderer
implements Handler.Callback {
    private static final int MSG_UPDATE_OVERLAY = 0;
    private final Handler textRendererHandler;
    private final TextRenderer textRenderer;
    private final SampleSource source;
    private final MediaFormatHolder formatHolder;
    private final SubtitleParser[] subtitleParsers;
    private int parserIndex;
    private int trackIndex;
    private long currentPositionUs;
    private boolean inputStreamEnded;
    private Subtitle subtitle;
    private SubtitleParserHelper parserHelper;
    private HandlerThread parserThread;
    private int nextSubtitleEventIndex;
    private boolean textRendererNeedsUpdate;

    public TextTrackRenderer(SampleSource source, TextRenderer textRenderer, Looper textRendererLooper, SubtitleParser ... subtitleParsers) {
        this.source = Assertions.checkNotNull(source);
        this.textRenderer = Assertions.checkNotNull(textRenderer);
        this.textRendererHandler = textRendererLooper == null ? null : new Handler(textRendererLooper, (Handler.Callback)this);
        this.subtitleParsers = Assertions.checkNotNull(subtitleParsers);
        this.formatHolder = new MediaFormatHolder();
    }

    @Override
    protected int doPrepare() throws ExoPlaybackException {
        try {
            boolean sourcePrepared = this.source.prepare();
            if (!sourcePrepared) {
                return 0;
            }
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        for (int i = 0; i < this.subtitleParsers.length; ++i) {
            for (int j = 0; j < this.source.getTrackCount(); ++j) {
                if (!this.subtitleParsers[i].canParse(this.source.getTrackInfo((int)j).mimeType)) continue;
                this.parserIndex = i;
                this.trackIndex = j;
                return 1;
            }
        }
        return -1;
    }

    @Override
    protected void onEnabled(long positionUs, boolean joining) {
        this.source.enable(this.trackIndex, positionUs);
        this.parserThread = new HandlerThread("textParser");
        this.parserThread.start();
        this.parserHelper = new SubtitleParserHelper(this.parserThread.getLooper(), this.subtitleParsers[this.parserIndex]);
        this.seekToInternal(positionUs);
    }

    @Override
    protected void seekTo(long positionUs) {
        this.source.seekToUs(positionUs);
        this.seekToInternal(positionUs);
    }

    private void seekToInternal(long positionUs) {
        this.inputStreamEnded = false;
        this.currentPositionUs = positionUs;
        this.source.seekToUs(positionUs);
        if (this.subtitle != null && (positionUs < this.subtitle.getStartTime() || this.subtitle.getLastEventTime() <= positionUs)) {
            this.subtitle = null;
        }
        this.parserHelper.flush();
        this.clearTextRenderer();
        this.syncNextEventIndex(positionUs);
        this.textRendererNeedsUpdate = this.subtitle != null;
    }

    @Override
    protected void doSomeWork(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        this.currentPositionUs = positionUs;
        try {
            this.source.continueBuffering(positionUs);
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        if (this.parserHelper.isParsing()) {
            return;
        }
        Subtitle dequeuedSubtitle = null;
        if (this.subtitle == null) {
            try {
                dequeuedSubtitle = this.parserHelper.getAndClearResult();
            }
            catch (IOException e) {
                throw new ExoPlaybackException(e);
            }
        }
        if (this.subtitle == null && dequeuedSubtitle != null) {
            this.subtitle = dequeuedSubtitle;
            this.syncNextEventIndex(positionUs);
            this.textRendererNeedsUpdate = true;
        } else if (this.subtitle != null) {
            long nextEventTimeUs = this.getNextEventTime();
            while (nextEventTimeUs <= positionUs) {
                ++this.nextSubtitleEventIndex;
                nextEventTimeUs = this.getNextEventTime();
                this.textRendererNeedsUpdate = true;
            }
            if (nextEventTimeUs == Long.MAX_VALUE) {
                this.subtitle = null;
            }
        }
        if (!this.inputStreamEnded && this.subtitle == null) {
            try {
                SampleHolder sampleHolder = this.parserHelper.getSampleHolder();
                int result = this.source.readData(this.trackIndex, positionUs, this.formatHolder, sampleHolder, false);
                if (result == -3) {
                    this.parserHelper.startParseOperation();
                    this.textRendererNeedsUpdate = false;
                } else if (result == -1) {
                    this.inputStreamEnded = true;
                }
            }
            catch (IOException e) {
                throw new ExoPlaybackException(e);
            }
        }
        if (this.textRendererNeedsUpdate && this.getState() == 3) {
            this.textRendererNeedsUpdate = false;
            if (this.subtitle == null) {
                this.clearTextRenderer();
            } else {
                this.updateTextRenderer(positionUs);
            }
        }
    }

    @Override
    protected void onDisabled() {
        this.subtitle = null;
        this.parserThread.quit();
        this.parserThread = null;
        this.parserHelper = null;
        this.clearTextRenderer();
        this.source.disable(this.trackIndex);
    }

    @Override
    protected void onReleased() {
        this.source.release();
    }

    @Override
    protected long getCurrentPositionUs() {
        return this.currentPositionUs;
    }

    @Override
    protected long getDurationUs() {
        return this.source.getTrackInfo((int)this.trackIndex).durationUs;
    }

    @Override
    protected long getBufferedPositionUs() {
        return -3L;
    }

    @Override
    protected boolean isEnded() {
        return this.inputStreamEnded && this.subtitle == null;
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    private void syncNextEventIndex(long positionUs) {
        this.nextSubtitleEventIndex = this.subtitle == null ? -1 : this.subtitle.getNextEventTimeIndex(positionUs);
    }

    private long getNextEventTime() {
        return this.nextSubtitleEventIndex == -1 || this.nextSubtitleEventIndex >= this.subtitle.getEventTimeCount() ? Long.MAX_VALUE : this.subtitle.getEventTime(this.nextSubtitleEventIndex);
    }

    private void updateTextRenderer(long positionUs) {
        String text = this.subtitle.getText(positionUs);
        if (this.textRendererHandler != null) {
            this.textRendererHandler.obtainMessage(0, (Object)text).sendToTarget();
        } else {
            this.invokeRendererInternal(text);
        }
    }

    private void clearTextRenderer() {
        if (this.textRendererHandler != null) {
            this.textRendererHandler.obtainMessage(0, null).sendToTarget();
        } else {
            this.invokeRendererInternal(null);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeRendererInternal((String)msg.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeRendererInternal(String text) {
        this.textRenderer.onText(text);
    }
}

