/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import android.net.Uri;
import android.util.Base64;
import android.util.Pair;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.ManifestParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SmoothStreamingManifestParser
implements ManifestParser<SmoothStreamingManifest> {
    private final XmlPullParserFactory xmlParserFactory;

    public SmoothStreamingManifestParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    @Override
    public SmoothStreamingManifest parse(InputStream inputStream, String inputEncoding, String contentId, Uri baseUri) throws IOException, ParserException {
        try {
            XmlPullParser xmlParser = this.xmlParserFactory.newPullParser();
            xmlParser.setInput(inputStream, inputEncoding);
            SmoothStreamMediaParser smoothStreamMediaParser = new SmoothStreamMediaParser(null, baseUri);
            return (SmoothStreamingManifest)smoothStreamMediaParser.parse(xmlParser);
        }
        catch (XmlPullParserException e) {
            throw new ParserException(e);
        }
    }

    private static class TrackElementParser
    extends ElementParser {
        public static final String TAG = "QualityLevel";
        private static final String KEY_INDEX = "Index";
        private static final String KEY_BITRATE = "Bitrate";
        private static final String KEY_CODEC_PRIVATE_DATA = "CodecPrivateData";
        private static final String KEY_SAMPLING_RATE = "SamplingRate";
        private static final String KEY_CHANNELS = "Channels";
        private static final String KEY_BITS_PER_SAMPLE = "BitsPerSample";
        private static final String KEY_PACKET_SIZE = "PacketSize";
        private static final String KEY_AUDIO_TAG = "AudioTag";
        private static final String KEY_FOUR_CC = "FourCC";
        private static final String KEY_NAL_UNIT_LENGTH_FIELD = "NALUnitLengthField";
        private static final String KEY_TYPE = "Type";
        private static final String KEY_MAX_WIDTH = "MaxWidth";
        private static final String KEY_MAX_HEIGHT = "MaxHeight";
        private final List<byte[]> csd = new LinkedList<byte[]>();
        private int index;
        private int bitrate;
        private String mimeType;
        private int profile;
        private int level;
        private int maxWidth;
        private int maxHeight;
        private int samplingRate;
        private int channels;
        private int packetSize;
        private int audioTag;
        private int bitPerSample;
        private int nalUnitLengthField;
        private String content;

        public TrackElementParser(ElementParser parent, Uri baseUri) {
            super(parent, baseUri, TAG);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            int type = (Integer)this.getNormalizedAttribute(KEY_TYPE);
            this.content = null;
            this.index = this.parseInt(parser, KEY_INDEX, -1);
            this.bitrate = this.parseRequiredInt(parser, KEY_BITRATE);
            this.nalUnitLengthField = this.parseInt(parser, KEY_NAL_UNIT_LENGTH_FIELD, 4);
            if (type == 1) {
                this.maxHeight = this.parseRequiredInt(parser, KEY_MAX_HEIGHT);
                this.maxWidth = this.parseRequiredInt(parser, KEY_MAX_WIDTH);
                this.mimeType = TrackElementParser.fourCCToMimeType(this.parseRequiredString(parser, KEY_FOUR_CC));
            } else {
                this.maxHeight = -1;
                this.maxWidth = -1;
                String fourCC = parser.getAttributeValue(null, KEY_FOUR_CC);
                String string = fourCC != null ? TrackElementParser.fourCCToMimeType(fourCC) : (this.mimeType = type == 0 ? "audio/mp4a-latm" : null);
            }
            if (type == 0) {
                this.samplingRate = this.parseRequiredInt(parser, KEY_SAMPLING_RATE);
                this.channels = this.parseRequiredInt(parser, KEY_CHANNELS);
                this.bitPerSample = this.parseRequiredInt(parser, KEY_BITS_PER_SAMPLE);
                this.packetSize = this.parseRequiredInt(parser, KEY_PACKET_SIZE);
                this.audioTag = this.parseRequiredInt(parser, KEY_AUDIO_TAG);
            } else {
                this.samplingRate = -1;
                this.channels = -1;
                this.bitPerSample = -1;
                this.packetSize = -1;
                this.audioTag = -1;
            }
            String value = parser.getAttributeValue(null, KEY_CODEC_PRIVATE_DATA);
            if (value != null && value.length() > 0) {
                byte[] codecPrivateData = TrackElementParser.hexStringToByteArray(value);
                byte[][] split = CodecSpecificDataUtil.splitNalUnits(codecPrivateData);
                if (split == null) {
                    this.csd.add(codecPrivateData);
                } else {
                    for (int i = 0; i < split.length; ++i) {
                        Pair<Integer, Integer> spsParameters = CodecSpecificDataUtil.parseSpsNalUnit(split[i]);
                        if (spsParameters != null) {
                            this.profile = (Integer)spsParameters.first;
                            this.level = (Integer)spsParameters.second;
                        }
                        this.csd.add(split[i]);
                    }
                }
            }
        }

        @Override
        public void parseText(XmlPullParser parser) {
            this.content = parser.getText();
        }

        @Override
        public Object build() {
            Object csdArray = null;
            if (!this.csd.isEmpty()) {
                csdArray = new byte[this.csd.size()][];
                this.csd.toArray((T[])csdArray);
            }
            return new SmoothStreamingManifest.TrackElement(this.index, this.bitrate, this.mimeType, (byte[][])csdArray, this.profile, this.level, this.maxWidth, this.maxHeight, this.samplingRate, this.channels, this.packetSize, this.audioTag, this.bitPerSample, this.nalUnitLengthField, this.content);
        }

        private static String fourCCToMimeType(String fourCC) {
            if (fourCC.equalsIgnoreCase("H264") || fourCC.equalsIgnoreCase("X264") || fourCC.equalsIgnoreCase("AVC1") || fourCC.equalsIgnoreCase("DAVC")) {
                return "video/avc";
            }
            if (fourCC.equalsIgnoreCase("AAC") || fourCC.equalsIgnoreCase("AACL") || fourCC.equalsIgnoreCase("AACH") || fourCC.equalsIgnoreCase("AACP")) {
                return "audio/mp4a-latm";
            }
            if (fourCC.equalsIgnoreCase("TTML")) {
                return "application/ttml+xml";
            }
            return null;
        }

        private static byte[] hexStringToByteArray(String hexString) {
            int length = hexString.length();
            byte[] data = new byte[length / 2];
            for (int i = 0; i < data.length; ++i) {
                int stringOffset = i * 2;
                data[i] = (byte)((Character.digit(hexString.charAt(stringOffset), 16) << 4) + Character.digit(hexString.charAt(stringOffset + 1), 16));
            }
            return data;
        }
    }

    private static class StreamElementParser
    extends ElementParser {
        public static final String TAG = "StreamIndex";
        private static final String TAG_STREAM_FRAGMENT = "c";
        private static final String KEY_TYPE = "Type";
        private static final String KEY_TYPE_AUDIO = "audio";
        private static final String KEY_TYPE_VIDEO = "video";
        private static final String KEY_TYPE_TEXT = "text";
        private static final String KEY_SUB_TYPE = "Subtype";
        private static final String KEY_NAME = "Name";
        private static final String KEY_QUALITY_LEVELS = "QualityLevels";
        private static final String KEY_URL = "Url";
        private static final String KEY_MAX_WIDTH = "MaxWidth";
        private static final String KEY_MAX_HEIGHT = "MaxHeight";
        private static final String KEY_DISPLAY_WIDTH = "DisplayWidth";
        private static final String KEY_DISPLAY_HEIGHT = "DisplayHeight";
        private static final String KEY_LANGUAGE = "Language";
        private static final String KEY_TIME_SCALE = "TimeScale";
        private static final String KEY_FRAGMENT_DURATION = "d";
        private static final String KEY_FRAGMENT_START_TIME = "t";
        private static final String KEY_FRAGMENT_REPEAT_COUNT = "r";
        private final Uri baseUri;
        private final List<SmoothStreamingManifest.TrackElement> tracks;
        private int type;
        private String subType;
        private long timescale;
        private String name;
        private int qualityLevels;
        private String url;
        private int maxWidth;
        private int maxHeight;
        private int displayWidth;
        private int displayHeight;
        private String language;
        private ArrayList<Long> startTimes;
        private long lastChunkDuration;

        public StreamElementParser(ElementParser parent, Uri baseUri) {
            super(parent, baseUri, TAG);
            this.baseUri = baseUri;
            this.tracks = new LinkedList<SmoothStreamingManifest.TrackElement>();
        }

        @Override
        public boolean handleChildInline(String tag) {
            return TAG_STREAM_FRAGMENT.equals(tag);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            if (TAG_STREAM_FRAGMENT.equals(parser.getName())) {
                this.parseStreamFragmentStartTag(parser);
            } else {
                this.parseStreamElementStartTag(parser);
            }
        }

        private void parseStreamFragmentStartTag(XmlPullParser parser) throws ParserException {
            int chunkIndex = this.startTimes.size();
            long startTime = this.parseLong(parser, KEY_FRAGMENT_START_TIME, -1L);
            if (startTime == -1L) {
                if (chunkIndex == 0) {
                    startTime = 0L;
                } else if (this.lastChunkDuration != -1L) {
                    startTime = this.startTimes.get(chunkIndex - 1) + this.lastChunkDuration;
                } else {
                    throw new ParserException("Unable to infer start time");
                }
            }
            ++chunkIndex;
            this.startTimes.add(startTime);
            this.lastChunkDuration = this.parseLong(parser, KEY_FRAGMENT_DURATION, -1L);
            long repeatCount = this.parseLong(parser, KEY_FRAGMENT_REPEAT_COUNT, 1L);
            if (repeatCount > 1L && this.lastChunkDuration == -1L) {
                throw new ParserException("Repeated chunk with unspecified duration");
            }
            int i = 1;
            while ((long)i < repeatCount) {
                ++chunkIndex;
                this.startTimes.add(startTime + this.lastChunkDuration * (long)i);
                ++i;
            }
        }

        private void parseStreamElementStartTag(XmlPullParser parser) throws ParserException {
            this.type = this.parseType(parser);
            this.putNormalizedAttribute(KEY_TYPE, this.type);
            this.subType = this.type == 2 ? this.parseRequiredString(parser, KEY_SUB_TYPE) : parser.getAttributeValue(null, KEY_SUB_TYPE);
            this.name = parser.getAttributeValue(null, KEY_NAME);
            this.qualityLevels = this.parseInt(parser, KEY_QUALITY_LEVELS, -1);
            this.url = this.parseRequiredString(parser, KEY_URL);
            this.maxWidth = this.parseInt(parser, KEY_MAX_WIDTH, -1);
            this.maxHeight = this.parseInt(parser, KEY_MAX_HEIGHT, -1);
            this.displayWidth = this.parseInt(parser, KEY_DISPLAY_WIDTH, -1);
            this.displayHeight = this.parseInt(parser, KEY_DISPLAY_HEIGHT, -1);
            this.language = parser.getAttributeValue(null, KEY_LANGUAGE);
            this.timescale = this.parseInt(parser, KEY_TIME_SCALE, -1);
            if (this.timescale == -1L) {
                this.timescale = (Long)this.getNormalizedAttribute(KEY_TIME_SCALE);
            }
            this.startTimes = new ArrayList();
        }

        private int parseType(XmlPullParser parser) throws ParserException {
            String value = parser.getAttributeValue(null, KEY_TYPE);
            if (value != null) {
                if (KEY_TYPE_AUDIO.equalsIgnoreCase(value)) {
                    return 0;
                }
                if (KEY_TYPE_VIDEO.equalsIgnoreCase(value)) {
                    return 1;
                }
                if (KEY_TYPE_TEXT.equalsIgnoreCase(value)) {
                    return 2;
                }
                throw new ParserException("Invalid key value[" + value + "]");
            }
            throw new MissingFieldException(KEY_TYPE);
        }

        @Override
        public void addChild(Object child) {
            if (child instanceof SmoothStreamingManifest.TrackElement) {
                this.tracks.add((SmoothStreamingManifest.TrackElement)child);
            }
        }

        @Override
        public Object build() {
            SmoothStreamingManifest.TrackElement[] trackElements = new SmoothStreamingManifest.TrackElement[this.tracks.size()];
            this.tracks.toArray(trackElements);
            return new SmoothStreamingManifest.StreamElement(this.baseUri, this.url, this.type, this.subType, this.timescale, this.name, this.qualityLevels, this.maxWidth, this.maxHeight, this.displayWidth, this.displayHeight, this.language, trackElements, this.startTimes, this.lastChunkDuration);
        }
    }

    private static class ProtectionElementParser
    extends ElementParser {
        public static final String TAG = "Protection";
        public static final String TAG_PROTECTION_HEADER = "ProtectionHeader";
        public static final String KEY_SYSTEM_ID = "SystemID";
        private boolean inProtectionHeader;
        private UUID uuid;
        private byte[] initData;

        public ProtectionElementParser(ElementParser parent, Uri baseUri) {
            super(parent, baseUri, TAG);
        }

        @Override
        public boolean handleChildInline(String tag) {
            return TAG_PROTECTION_HEADER.equals(tag);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) {
            if (TAG_PROTECTION_HEADER.equals(parser.getName())) {
                this.inProtectionHeader = true;
                String uuidString = parser.getAttributeValue(null, KEY_SYSTEM_ID);
                this.uuid = UUID.fromString(uuidString);
            }
        }

        @Override
        public void parseText(XmlPullParser parser) {
            if (this.inProtectionHeader) {
                this.initData = Base64.decode((String)parser.getText(), (int)0);
            }
        }

        @Override
        public void parseEndTag(XmlPullParser parser) {
            if (TAG_PROTECTION_HEADER.equals(parser.getName())) {
                this.inProtectionHeader = false;
            }
        }

        @Override
        public Object build() {
            return new SmoothStreamingManifest.ProtectionElement(this.uuid, this.initData);
        }
    }

    private static class SmoothStreamMediaParser
    extends ElementParser {
        public static final String TAG = "SmoothStreamingMedia";
        private static final String KEY_MAJOR_VERSION = "MajorVersion";
        private static final String KEY_MINOR_VERSION = "MinorVersion";
        private static final String KEY_TIME_SCALE = "TimeScale";
        private static final String KEY_DVR_WINDOW_LENGTH = "DVRWindowLength";
        private static final String KEY_DURATION = "Duration";
        private static final String KEY_LOOKAHEAD_COUNT = "LookaheadCount";
        private static final String KEY_IS_LIVE = "IsLive";
        private int majorVersion;
        private int minorVersion;
        private long timescale;
        private long duration;
        private long dvrWindowLength;
        private int lookAheadCount = -1;
        private boolean isLive;
        private SmoothStreamingManifest.ProtectionElement protectionElement = null;
        private List<SmoothStreamingManifest.StreamElement> streamElements = new LinkedList<SmoothStreamingManifest.StreamElement>();

        public SmoothStreamMediaParser(ElementParser parent, Uri baseUri) {
            super(parent, baseUri, TAG);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            this.majorVersion = this.parseRequiredInt(parser, KEY_MAJOR_VERSION);
            this.minorVersion = this.parseRequiredInt(parser, KEY_MINOR_VERSION);
            this.timescale = this.parseLong(parser, KEY_TIME_SCALE, 10000000L);
            this.duration = this.parseRequiredLong(parser, KEY_DURATION);
            this.dvrWindowLength = this.parseLong(parser, KEY_DVR_WINDOW_LENGTH, 0L);
            this.lookAheadCount = this.parseInt(parser, KEY_LOOKAHEAD_COUNT, -1);
            this.isLive = this.parseBoolean(parser, KEY_IS_LIVE, false);
            this.putNormalizedAttribute(KEY_TIME_SCALE, this.timescale);
        }

        @Override
        public void addChild(Object child) {
            if (child instanceof SmoothStreamingManifest.StreamElement) {
                this.streamElements.add((SmoothStreamingManifest.StreamElement)child);
            } else if (child instanceof SmoothStreamingManifest.ProtectionElement) {
                Assertions.checkState(this.protectionElement == null);
                this.protectionElement = (SmoothStreamingManifest.ProtectionElement)child;
            }
        }

        @Override
        public Object build() {
            SmoothStreamingManifest.StreamElement[] streamElementArray = new SmoothStreamingManifest.StreamElement[this.streamElements.size()];
            this.streamElements.toArray(streamElementArray);
            return new SmoothStreamingManifest(this.majorVersion, this.minorVersion, this.timescale, this.duration, this.dvrWindowLength, this.lookAheadCount, this.isLive, this.protectionElement, streamElementArray);
        }
    }

    private static abstract class ElementParser {
        private final Uri baseUri;
        private final String tag;
        private final ElementParser parent;
        private final List<Pair<String, Object>> normalizedAttributes;

        public ElementParser(ElementParser parent, Uri baseUri, String tag) {
            this.parent = parent;
            this.baseUri = baseUri;
            this.tag = tag;
            this.normalizedAttributes = new LinkedList<Pair<String, Object>>();
        }

        public final Object parse(XmlPullParser xmlParser) throws XmlPullParserException, IOException, ParserException {
            boolean foundStartTag = false;
            int skippingElementDepth = 0;
            while (true) {
                int eventType = xmlParser.getEventType();
                switch (eventType) {
                    case 2: {
                        String tagName = xmlParser.getName();
                        if (this.tag.equals(tagName)) {
                            foundStartTag = true;
                            this.parseStartTag(xmlParser);
                            break;
                        }
                        if (!foundStartTag) break;
                        if (skippingElementDepth > 0) {
                            ++skippingElementDepth;
                            break;
                        }
                        if (this.handleChildInline(tagName)) {
                            this.parseStartTag(xmlParser);
                            break;
                        }
                        ElementParser childElementParser = this.newChildParser(this, tagName, this.baseUri);
                        if (childElementParser == null) {
                            skippingElementDepth = 1;
                            break;
                        }
                        this.addChild(childElementParser.parse(xmlParser));
                        break;
                    }
                    case 4: {
                        if (!foundStartTag || skippingElementDepth != 0) break;
                        this.parseText(xmlParser);
                        break;
                    }
                    case 3: {
                        if (!foundStartTag) break;
                        if (skippingElementDepth > 0) {
                            --skippingElementDepth;
                            break;
                        }
                        String tagName = xmlParser.getName();
                        this.parseEndTag(xmlParser);
                        if (this.handleChildInline(tagName)) break;
                        return this.build();
                    }
                    case 1: {
                        return null;
                    }
                }
                xmlParser.next();
            }
        }

        private ElementParser newChildParser(ElementParser parent, String name, Uri baseUri) {
            if ("QualityLevel".equals(name)) {
                return new TrackElementParser(parent, baseUri);
            }
            if ("Protection".equals(name)) {
                return new ProtectionElementParser(parent, baseUri);
            }
            if ("StreamIndex".equals(name)) {
                return new StreamElementParser(parent, baseUri);
            }
            return null;
        }

        protected final void putNormalizedAttribute(String key, Object value) {
            this.normalizedAttributes.add((Pair<String, Object>)Pair.create((Object)key, (Object)value));
        }

        protected final Object getNormalizedAttribute(String key) {
            for (int i = 0; i < this.normalizedAttributes.size(); ++i) {
                Pair<String, Object> pair = this.normalizedAttributes.get(i);
                if (!((String)pair.first).equals(key)) continue;
                return pair.second;
            }
            return this.parent == null ? null : this.parent.getNormalizedAttribute(key);
        }

        protected boolean handleChildInline(String tagName) {
            return false;
        }

        protected void parseStartTag(XmlPullParser xmlParser) throws ParserException {
        }

        protected void parseText(XmlPullParser xmlParser) throws ParserException {
        }

        protected void parseEndTag(XmlPullParser xmlParser) throws ParserException {
        }

        protected void addChild(Object parsedChild) {
        }

        protected abstract Object build();

        protected final String parseRequiredString(XmlPullParser parser, String key) throws MissingFieldException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                return value;
            }
            throw new MissingFieldException(key);
        }

        protected final int parseInt(XmlPullParser parser, String key, int defaultValue) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(e);
                }
            }
            return defaultValue;
        }

        protected final int parseRequiredInt(XmlPullParser parser, String key) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(e);
                }
            }
            throw new MissingFieldException(key);
        }

        protected final long parseLong(XmlPullParser parser, String key, long defaultValue) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(e);
                }
            }
            return defaultValue;
        }

        protected final long parseRequiredLong(XmlPullParser parser, String key) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(e);
                }
            }
            throw new MissingFieldException(key);
        }

        protected final boolean parseBoolean(XmlPullParser parser, String key, boolean defaultValue) {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
            return defaultValue;
        }
    }

    public static class MissingFieldException
    extends ParserException {
        public MissingFieldException(String fieldName) {
            super("Missing required field: " + fieldName);
        }
    }
}

