/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.parser.webm;

import android.annotation.TargetApi;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.parser.Extractor;
import com.google.android.exoplayer.parser.SegmentIndex;
import com.google.android.exoplayer.parser.webm.DefaultEbmlReader;
import com.google.android.exoplayer.parser.webm.EbmlEventHandler;
import com.google.android.exoplayer.parser.webm.EbmlReader;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.util.LongArray;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@TargetApi(value=16)
public final class WebmExtractor
implements Extractor {
    private static final String DOC_TYPE_WEBM = "webm";
    private static final String CODEC_ID_VP9 = "V_VP9";
    private static final String CODEC_ID_VORBIS = "A_VORBIS";
    private static final String CODEC_ID_OPUS = "A_OPUS";
    private static final int VORBIS_MAX_INPUT_SIZE = 8192;
    private static final int OPUS_MAX_INPUT_SIZE = 5760;
    private static final int UNKNOWN = -1;
    private static final int ID_EBML = 440786851;
    private static final int ID_EBML_READ_VERSION = 17143;
    private static final int ID_DOC_TYPE = 17026;
    private static final int ID_DOC_TYPE_READ_VERSION = 17029;
    private static final int ID_SEGMENT = 408125543;
    private static final int ID_INFO = 357149030;
    private static final int ID_TIMECODE_SCALE = 2807729;
    private static final int ID_DURATION = 17545;
    private static final int ID_CLUSTER = 524531317;
    private static final int ID_TIME_CODE = 231;
    private static final int ID_SIMPLE_BLOCK = 163;
    private static final int ID_BLOCK_GROUP = 160;
    private static final int ID_BLOCK = 161;
    private static final int ID_TRACKS = 374648427;
    private static final int ID_TRACK_ENTRY = 174;
    private static final int ID_CODEC_ID = 134;
    private static final int ID_CODEC_PRIVATE = 25506;
    private static final int ID_CODEC_DELAY = 22186;
    private static final int ID_SEEK_PRE_ROLL = 22203;
    private static final int ID_VIDEO = 224;
    private static final int ID_PIXEL_WIDTH = 176;
    private static final int ID_PIXEL_HEIGHT = 186;
    private static final int ID_AUDIO = 225;
    private static final int ID_CHANNELS = 159;
    private static final int ID_SAMPLING_FREQUENCY = 181;
    private static final int ID_CUES = 475249515;
    private static final int ID_CUE_POINT = 187;
    private static final int ID_CUE_TIME = 179;
    private static final int ID_CUE_TRACK_POSITIONS = 183;
    private static final int ID_CUE_CLUSTER_POSITION = 241;
    private static final int LACING_NONE = 0;
    private static final int LACING_XIPH = 1;
    private static final int LACING_FIXED = 2;
    private static final int LACING_EBML = 3;
    private static final int READ_TERMINATING_RESULTS = 39;
    private final EbmlReader reader;
    private final byte[] simpleBlockTimecodeAndFlags = new byte[3];
    private SampleHolder sampleHolder;
    private int readResults;
    private long segmentStartOffsetBytes = -1L;
    private long segmentEndOffsetBytes = -1L;
    private long timecodeScale = 1000000L;
    private long durationUs = -1L;
    private int pixelWidth = -1;
    private int pixelHeight = -1;
    private int channelCount = -1;
    private int sampleRate = -1;
    private byte[] codecPrivate;
    private String codecId;
    private long codecDelayNs;
    private long seekPreRollNs;
    private boolean seenAudioTrack;
    private long cuesSizeBytes = -1L;
    private long clusterTimecodeUs = -1L;
    private long simpleBlockTimecodeUs = -1L;
    private MediaFormat format;
    private SegmentIndex cues;
    private LongArray cueTimesUs;
    private LongArray cueClusterPositions;

    public WebmExtractor() {
        this(new DefaultEbmlReader());
    }

    WebmExtractor(EbmlReader reader) {
        this.reader = reader;
        this.reader.setEventHandler(new InnerEbmlEventHandler());
    }

    @Override
    public int read(NonBlockingInputStream inputStream, SampleHolder sampleHolder) throws ParserException {
        this.sampleHolder = sampleHolder;
        this.readResults = 0;
        while ((this.readResults & 0x27) == 0) {
            int ebmlReadResult = this.reader.read(inputStream);
            if (ebmlReadResult == 1) {
                this.readResults |= 1;
                continue;
            }
            if (ebmlReadResult != 2) continue;
            this.readResults |= 2;
        }
        this.sampleHolder = null;
        return this.readResults;
    }

    @Override
    public boolean seekTo(long seekTimeUs, boolean allowNoop) {
        int clusterIndex;
        if (allowNoop && this.cues != null && this.clusterTimecodeUs != -1L && this.simpleBlockTimecodeUs != -1L && seekTimeUs >= this.simpleBlockTimecodeUs && (clusterIndex = Arrays.binarySearch(this.cues.timesUs, this.clusterTimecodeUs)) >= 0 && seekTimeUs < this.clusterTimecodeUs + this.cues.durationsUs[clusterIndex]) {
            return false;
        }
        this.clusterTimecodeUs = -1L;
        this.simpleBlockTimecodeUs = -1L;
        this.reader.reset();
        return true;
    }

    @Override
    public SegmentIndex getIndex() {
        return this.cues;
    }

    @Override
    public boolean hasRelativeIndexOffsets() {
        return false;
    }

    @Override
    public MediaFormat getFormat() {
        return this.format;
    }

    @Override
    public Map<UUID, byte[]> getPsshInfo() {
        return null;
    }

    int getElementType(int id) {
        switch (id) {
            case 160: 
            case 174: 
            case 183: 
            case 187: 
            case 224: 
            case 225: 
            case 357149030: 
            case 374648427: 
            case 408125543: 
            case 440786851: 
            case 475249515: 
            case 524531317: {
                return 1;
            }
            case 159: 
            case 176: 
            case 179: 
            case 186: 
            case 231: 
            case 241: 
            case 17029: 
            case 17143: 
            case 22186: 
            case 22203: 
            case 2807729: {
                return 2;
            }
            case 134: 
            case 17026: {
                return 3;
            }
            case 161: 
            case 163: 
            case 25506: {
                return 4;
            }
            case 181: 
            case 17545: {
                return 5;
            }
        }
        return 0;
    }

    boolean onMasterElementStart(int id, long elementOffsetBytes, int headerSizeBytes, long contentsSizeBytes) throws ParserException {
        switch (id) {
            case 408125543: {
                if (this.segmentStartOffsetBytes != -1L || this.segmentEndOffsetBytes != -1L) {
                    throw new ParserException("Multiple Segment elements not supported");
                }
                this.segmentStartOffsetBytes = elementOffsetBytes + (long)headerSizeBytes;
                this.segmentEndOffsetBytes = elementOffsetBytes + (long)headerSizeBytes + contentsSizeBytes;
                break;
            }
            case 475249515: {
                this.cuesSizeBytes = (long)headerSizeBytes + contentsSizeBytes;
                this.cueTimesUs = new LongArray();
                this.cueClusterPositions = new LongArray();
                break;
            }
        }
        return true;
    }

    boolean onMasterElementEnd(int id) throws ParserException {
        switch (id) {
            case 475249515: {
                this.buildCues();
                return false;
            }
            case 224: {
                this.buildVideoFormat();
                return true;
            }
            case 225: {
                this.seenAudioTrack = true;
                return true;
            }
            case 174: {
                if (this.seenAudioTrack) {
                    this.buildAudioFormat();
                }
                return true;
            }
        }
        return true;
    }

    boolean onIntegerElement(int id, long value) throws ParserException {
        switch (id) {
            case 17143: {
                if (value == 1L) break;
                throw new ParserException("EBMLReadVersion " + value + " not supported");
            }
            case 17029: {
                if (value >= 1L && value <= 2L) break;
                throw new ParserException("DocTypeReadVersion " + value + " not supported");
            }
            case 2807729: {
                this.timecodeScale = value;
                break;
            }
            case 176: {
                this.pixelWidth = (int)value;
                break;
            }
            case 186: {
                this.pixelHeight = (int)value;
                break;
            }
            case 22186: {
                this.codecDelayNs = value;
                break;
            }
            case 22203: {
                this.seekPreRollNs = value;
                break;
            }
            case 159: {
                this.channelCount = (int)value;
                break;
            }
            case 179: {
                this.cueTimesUs.add(this.scaleTimecodeToUs(value));
                break;
            }
            case 241: {
                this.cueClusterPositions.add(value);
                break;
            }
            case 231: {
                this.clusterTimecodeUs = this.scaleTimecodeToUs(value);
                break;
            }
        }
        return true;
    }

    boolean onFloatElement(int id, double value) {
        switch (id) {
            case 17545: {
                this.durationUs = this.scaleTimecodeToUs((long)value);
                break;
            }
            case 181: {
                this.sampleRate = (int)value;
                break;
            }
        }
        return true;
    }

    boolean onStringElement(int id, String value) throws ParserException {
        switch (id) {
            case 17026: {
                if (DOC_TYPE_WEBM.equals(value)) break;
                throw new ParserException("DocType " + value + " not supported");
            }
            case 134: {
                if (!this.isCodecSupported(value)) {
                    throw new ParserException("CodecID " + value + " not supported");
                }
                this.codecId = value;
                break;
            }
        }
        return true;
    }

    boolean onBinaryElement(int id, long elementOffsetBytes, int headerSizeBytes, int contentsSizeBytes, NonBlockingInputStream inputStream) throws ParserException {
        switch (id) {
            case 161: 
            case 163: {
                ByteBuffer outputData;
                if (this.sampleHolder == null) {
                    this.readResults |= 0x20;
                    return false;
                }
                this.reader.readVarint(inputStream);
                this.reader.readBytes(inputStream, this.simpleBlockTimecodeAndFlags, 3);
                int timecode = this.simpleBlockTimecodeAndFlags[0] << 8 | this.simpleBlockTimecodeAndFlags[1] & 0xFF;
                long timecodeUs = this.scaleTimecodeToUs(timecode);
                boolean keyframe = id == 161 ? true : (this.simpleBlockTimecodeAndFlags[2] & 0x80) == 128;
                boolean invisible = (this.simpleBlockTimecodeAndFlags[2] & 8) == 8;
                int lacing = (this.simpleBlockTimecodeAndFlags[2] & 6) >> 1;
                switch (lacing) {
                    case 0: {
                        long elementEndOffsetBytes = elementOffsetBytes + (long)headerSizeBytes + (long)contentsSizeBytes;
                        this.simpleBlockTimecodeUs = this.clusterTimecodeUs + timecodeUs;
                        this.sampleHolder.flags = keyframe ? 1 : 0;
                        this.sampleHolder.decodeOnly = invisible;
                        this.sampleHolder.timeUs = this.clusterTimecodeUs + timecodeUs;
                        this.sampleHolder.size = (int)(elementEndOffsetBytes - this.reader.getBytesRead());
                        break;
                    }
                    default: {
                        throw new ParserException("Lacing mode " + lacing + " not supported");
                    }
                }
                if (this.sampleHolder.data == null || this.sampleHolder.data.capacity() < this.sampleHolder.size) {
                    this.sampleHolder.replaceBuffer(this.sampleHolder.size);
                }
                if ((outputData = this.sampleHolder.data) == null) {
                    this.reader.skipBytes(inputStream, this.sampleHolder.size);
                    this.sampleHolder.size = 0;
                } else {
                    this.reader.readBytes(inputStream, outputData, this.sampleHolder.size);
                }
                this.readResults |= 4;
                break;
            }
            case 25506: {
                this.codecPrivate = new byte[contentsSizeBytes];
                this.reader.readBytes(inputStream, this.codecPrivate, contentsSizeBytes);
                break;
            }
        }
        return true;
    }

    private long scaleTimecodeToUs(long unscaledTimecode) {
        return TimeUnit.NANOSECONDS.toMicros(unscaledTimecode * this.timecodeScale);
    }

    private boolean isCodecSupported(String codecId) {
        return CODEC_ID_VP9.equals(codecId) || CODEC_ID_OPUS.equals(codecId) || CODEC_ID_VORBIS.equals(codecId);
    }

    private void buildVideoFormat() throws ParserException {
        if (this.pixelWidth != -1 && this.pixelHeight != -1 && (this.format == null || this.format.width != this.pixelWidth || this.format.height != this.pixelHeight)) {
            this.format = MediaFormat.createVideoFormat("video/x-vnd.on2.vp9", -1, this.pixelWidth, this.pixelHeight, null);
            this.readResults |= 8;
        } else if (this.format == null) {
            throw new ParserException("Unable to build format");
        }
    }

    private void buildAudioFormat() throws ParserException {
        if (this.channelCount != -1 && this.sampleRate != -1 && (this.format == null || this.format.channelCount != this.channelCount || this.format.sampleRate != this.sampleRate)) {
            if (CODEC_ID_VORBIS.equals(this.codecId)) {
                this.format = MediaFormat.createAudioFormat("audio/vorbis", 8192, this.channelCount, this.sampleRate, this.parseVorbisCodecPrivate());
            } else if (CODEC_ID_OPUS.equals(this.codecId)) {
                ArrayList<byte[]> opusInitializationData = new ArrayList<byte[]>(3);
                opusInitializationData.add(this.codecPrivate);
                opusInitializationData.add(ByteBuffer.allocate(64).putLong(this.codecDelayNs).array());
                opusInitializationData.add(ByteBuffer.allocate(64).putLong(this.seekPreRollNs).array());
                this.format = MediaFormat.createAudioFormat("audio/opus", 5760, this.channelCount, this.sampleRate, opusInitializationData);
            }
            this.readResults |= 8;
        } else if (this.format == null) {
            throw new ParserException("Unable to build format");
        }
    }

    private void buildCues() throws ParserException {
        int i;
        if (this.segmentStartOffsetBytes == -1L) {
            throw new ParserException("Segment start/end offsets unknown");
        }
        if (this.durationUs == -1L) {
            throw new ParserException("Duration unknown");
        }
        if (this.cuesSizeBytes == -1L) {
            throw new ParserException("Cues size unknown");
        }
        if (this.cueTimesUs == null || this.cueClusterPositions == null || this.cueTimesUs.size() == 0 || this.cueTimesUs.size() != this.cueClusterPositions.size()) {
            throw new ParserException("Invalid/missing cue points");
        }
        int cuePointsSize = this.cueTimesUs.size();
        int[] sizes = new int[cuePointsSize];
        long[] offsets = new long[cuePointsSize];
        long[] durationsUs = new long[cuePointsSize];
        long[] timesUs = new long[cuePointsSize];
        for (i = 0; i < cuePointsSize; ++i) {
            timesUs[i] = this.cueTimesUs.get(i);
            offsets[i] = this.segmentStartOffsetBytes + this.cueClusterPositions.get(i);
        }
        for (i = 0; i < cuePointsSize - 1; ++i) {
            sizes[i] = (int)(offsets[i + 1] - offsets[i]);
            durationsUs[i] = timesUs[i + 1] - timesUs[i];
        }
        sizes[cuePointsSize - 1] = (int)(this.segmentEndOffsetBytes - offsets[cuePointsSize - 1]);
        durationsUs[cuePointsSize - 1] = this.durationUs - timesUs[cuePointsSize - 1];
        this.cues = new SegmentIndex((int)this.cuesSizeBytes, sizes, offsets, durationsUs, timesUs);
        this.cueTimesUs = null;
        this.cueClusterPositions = null;
        this.readResults |= 0x10;
    }

    private ArrayList<byte[]> parseVorbisCodecPrivate() throws ParserException {
        try {
            if (this.codecPrivate[0] != 2) {
                throw new ParserException("Error parsing vorbis codec private");
            }
            int offset = 1;
            int vorbisInfoLength = 0;
            while (this.codecPrivate[offset] == -1) {
                vorbisInfoLength += 255;
                ++offset;
            }
            vorbisInfoLength += this.codecPrivate[offset++];
            int vorbisSkipLength = 0;
            while (this.codecPrivate[offset] == -1) {
                vorbisSkipLength += 255;
                ++offset;
            }
            vorbisSkipLength += this.codecPrivate[offset++];
            if (this.codecPrivate[offset] != 1) {
                throw new ParserException("Error parsing vorbis codec private");
            }
            byte[] vorbisInfo = new byte[vorbisInfoLength];
            System.arraycopy(this.codecPrivate, offset, vorbisInfo, 0, vorbisInfoLength);
            if (this.codecPrivate[offset += vorbisInfoLength] != 3) {
                throw new ParserException("Error parsing vorbis codec private");
            }
            if (this.codecPrivate[offset += vorbisSkipLength] != 5) {
                throw new ParserException("Error parsing vorbis codec private");
            }
            byte[] vorbisBooks = new byte[this.codecPrivate.length - offset];
            System.arraycopy(this.codecPrivate, offset, vorbisBooks, 0, this.codecPrivate.length - offset);
            ArrayList<byte[]> initializationData = new ArrayList<byte[]>(2);
            initializationData.add(vorbisInfo);
            initializationData.add(vorbisBooks);
            return initializationData;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParserException("Error parsing vorbis codec private");
        }
    }

    private final class InnerEbmlEventHandler
    implements EbmlEventHandler {
        private InnerEbmlEventHandler() {
        }

        @Override
        public int getElementType(int id) {
            return WebmExtractor.this.getElementType(id);
        }

        @Override
        public void onMasterElementStart(int id, long elementOffsetBytes, int headerSizeBytes, long contentsSizeBytes) throws ParserException {
            WebmExtractor.this.onMasterElementStart(id, elementOffsetBytes, headerSizeBytes, contentsSizeBytes);
        }

        @Override
        public void onMasterElementEnd(int id) throws ParserException {
            WebmExtractor.this.onMasterElementEnd(id);
        }

        @Override
        public void onIntegerElement(int id, long value) throws ParserException {
            WebmExtractor.this.onIntegerElement(id, value);
        }

        @Override
        public void onFloatElement(int id, double value) {
            WebmExtractor.this.onFloatElement(id, value);
        }

        @Override
        public void onStringElement(int id, String value) throws ParserException {
            WebmExtractor.this.onStringElement(id, value);
        }

        @Override
        public boolean onBinaryElement(int id, long elementOffsetBytes, int headerSizeBytes, int contentsSizeBytes, NonBlockingInputStream inputStream) throws ParserException {
            return WebmExtractor.this.onBinaryElement(id, elementOffsetBytes, headerSizeBytes, contentsSizeBytes, inputStream);
        }
    }
}

