/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.parser.mp4;

import com.google.android.exoplayer.parser.mp4.ParsableByteArray;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;

final class TrackFragment {
    public int sampleDescriptionIndex;
    public int length;
    public int[] sampleSizeTable;
    public int[] sampleCompositionTimeOffsetTable;
    public long[] sampleDecodingTimeTable;
    public boolean[] sampleIsSyncFrameTable;
    public boolean definesEncryptionData;
    public boolean[] sampleHasSubsampleEncryptionTable;
    public int sampleEncryptionDataLength;
    public ParsableByteArray sampleEncryptionData;
    public boolean sampleEncryptionDataNeedsFill;

    TrackFragment() {
    }

    public void reset() {
        this.length = 0;
        this.definesEncryptionData = false;
        this.sampleEncryptionDataNeedsFill = false;
    }

    public void initTables(int sampleCount) {
        this.length = sampleCount;
        if (this.sampleSizeTable == null || this.sampleSizeTable.length < this.length) {
            int tableSize = sampleCount * 125 / 100;
            this.sampleSizeTable = new int[tableSize];
            this.sampleCompositionTimeOffsetTable = new int[tableSize];
            this.sampleDecodingTimeTable = new long[tableSize];
            this.sampleIsSyncFrameTable = new boolean[tableSize];
            this.sampleHasSubsampleEncryptionTable = new boolean[tableSize];
        }
    }

    public void initEncryptionData(int length) {
        if (this.sampleEncryptionData == null || this.sampleEncryptionData.length() < length) {
            this.sampleEncryptionData = new ParsableByteArray(length);
        }
        this.sampleEncryptionDataLength = length;
        this.definesEncryptionData = true;
        this.sampleEncryptionDataNeedsFill = true;
    }

    public void fillEncryptionData(ParsableByteArray source) {
        source.readBytes(this.sampleEncryptionData.data, 0, this.sampleEncryptionDataLength);
        this.sampleEncryptionData.setPosition(0);
        this.sampleEncryptionDataNeedsFill = false;
    }

    public boolean fillEncryptionData(NonBlockingInputStream source) {
        if (source.getAvailableByteCount() < (long)this.sampleEncryptionDataLength) {
            return false;
        }
        source.read(this.sampleEncryptionData.data, 0, this.sampleEncryptionDataLength);
        this.sampleEncryptionData.setPosition(0);
        this.sampleEncryptionDataNeedsFill = false;
        return true;
    }

    public long getSamplePresentationTime(int index) {
        return this.sampleDecodingTimeTable[index] + (long)this.sampleCompositionTimeOffsetTable[index];
    }
}

