/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.metadata;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.metadata.MetadataParser;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public class MetadataTrackRenderer<T>
extends TrackRenderer
implements Handler.Callback {
    private static final int MSG_INVOKE_RENDERER = 0;
    private final SampleSource source;
    private final MetadataParser<T> metadataParser;
    private final MetadataRenderer<T> metadataRenderer;
    private final Handler metadataHandler;
    private final MediaFormatHolder formatHolder;
    private final SampleHolder sampleHolder;
    private int trackIndex;
    private long currentPositionUs;
    private boolean inputStreamEnded;
    private long pendingMetadataTimestamp;
    private T pendingMetadata;

    public MetadataTrackRenderer(SampleSource source, MetadataParser<T> metadataParser, MetadataRenderer<T> metadataRenderer, Looper metadataRendererLooper) {
        this.source = Assertions.checkNotNull(source);
        this.metadataParser = Assertions.checkNotNull(metadataParser);
        this.metadataRenderer = Assertions.checkNotNull(metadataRenderer);
        this.metadataHandler = metadataRendererLooper == null ? null : new Handler(metadataRendererLooper, (Handler.Callback)this);
        this.formatHolder = new MediaFormatHolder();
        this.sampleHolder = new SampleHolder(1);
    }

    @Override
    protected int doPrepare() throws ExoPlaybackException {
        try {
            boolean sourcePrepared = this.source.prepare();
            if (!sourcePrepared) {
                return 0;
            }
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        for (int i = 0; i < this.source.getTrackCount(); ++i) {
            if (!this.metadataParser.canParse(this.source.getTrackInfo((int)i).mimeType)) continue;
            this.trackIndex = i;
            return 1;
        }
        return -1;
    }

    @Override
    protected void onEnabled(long positionUs, boolean joining) {
        this.source.enable(this.trackIndex, positionUs);
        this.seekToInternal(positionUs);
    }

    @Override
    protected void seekTo(long positionUs) throws ExoPlaybackException {
        this.source.seekToUs(positionUs);
        this.seekToInternal(positionUs);
    }

    private void seekToInternal(long positionUs) {
        this.currentPositionUs = positionUs;
        this.pendingMetadata = null;
        this.inputStreamEnded = false;
    }

    @Override
    protected void doSomeWork(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        this.currentPositionUs = positionUs;
        try {
            this.source.continueBuffering(positionUs);
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        if (!this.inputStreamEnded && this.pendingMetadata == null) {
            try {
                int result = this.source.readData(this.trackIndex, positionUs, this.formatHolder, this.sampleHolder, false);
                if (result == -3) {
                    this.pendingMetadataTimestamp = this.sampleHolder.timeUs;
                    this.pendingMetadata = this.metadataParser.parse(this.sampleHolder.data.array(), this.sampleHolder.size);
                    this.sampleHolder.data.clear();
                } else if (result == -1) {
                    this.inputStreamEnded = true;
                }
            }
            catch (IOException e) {
                throw new ExoPlaybackException(e);
            }
        }
        if (this.pendingMetadata != null && this.pendingMetadataTimestamp <= this.currentPositionUs) {
            this.invokeRenderer(this.pendingMetadata);
            this.pendingMetadata = null;
        }
    }

    @Override
    protected void onDisabled() {
        this.pendingMetadata = null;
        this.source.disable(this.trackIndex);
    }

    @Override
    protected long getDurationUs() {
        return this.source.getTrackInfo((int)this.trackIndex).durationUs;
    }

    @Override
    protected long getCurrentPositionUs() {
        return this.currentPositionUs;
    }

    @Override
    protected long getBufferedPositionUs() {
        return -3L;
    }

    @Override
    protected boolean isEnded() {
        return this.inputStreamEnded;
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    private void invokeRenderer(T metadata) {
        if (this.metadataHandler != null) {
            this.metadataHandler.obtainMessage(0, metadata).sendToTarget();
        } else {
            this.invokeRendererInternal(metadata);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeRendererInternal(msg.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeRendererInternal(T metadata) {
        this.metadataRenderer.onMetadata(metadata);
    }

    public static interface MetadataRenderer<T> {
        public void onMetadata(T var1);
    }
}

