/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.metadata;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.metadata.MetadataParser;
import com.google.android.exoplayer.metadata.TxxxMetadata;
import com.google.android.exoplayer.util.BitArray;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Id3Parser
implements MetadataParser<Map<String, Object>> {
    @Override
    public boolean canParse(String mimeType) {
        return mimeType.equals("application/id3");
    }

    @Override
    public Map<String, Object> parse(byte[] data, int size) throws UnsupportedEncodingException, ParserException {
        int frameSize;
        BitArray id3Buffer = new BitArray(data, size);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (int id3Size = Id3Parser.parseId3Header(id3Buffer); id3Size > 0; id3Size -= frameSize + 10) {
            int frameId0 = id3Buffer.readUnsignedByte();
            int frameId1 = id3Buffer.readUnsignedByte();
            int frameId2 = id3Buffer.readUnsignedByte();
            int frameId3 = id3Buffer.readUnsignedByte();
            frameSize = id3Buffer.readSynchSafeInt();
            if (frameSize <= 1) break;
            id3Buffer.skipBytes(2);
            if (frameId0 == 84 && frameId1 == 88 && frameId2 == 88 && frameId3 == 88) {
                int encoding = id3Buffer.readUnsignedByte();
                String charset = Id3Parser.getCharsetName(encoding);
                byte[] frame = new byte[frameSize - 1];
                id3Buffer.readBytes(frame, 0, frameSize - 1);
                int firstZeroIndex = Id3Parser.indexOf(frame, 0, (byte)0);
                String description = new String(frame, 0, firstZeroIndex, charset);
                int valueStartIndex = Id3Parser.indexOfNot(frame, firstZeroIndex, (byte)0);
                int valueEndIndex = Id3Parser.indexOf(frame, valueStartIndex, (byte)0);
                String value = new String(frame, valueStartIndex, valueEndIndex - valueStartIndex, charset);
                metadata.put("TXXX", new TxxxMetadata(description, value));
                continue;
            }
            String type = String.format("%c%c%c%c", frameId0, frameId1, frameId2, frameId3);
            byte[] frame = new byte[frameSize];
            id3Buffer.readBytes(frame, 0, frameSize);
            metadata.put(type, frame);
        }
        return Collections.unmodifiableMap(metadata);
    }

    private static int indexOf(byte[] data, int fromIndex, byte key) {
        for (int i = fromIndex; i < data.length; ++i) {
            if (data[i] != key) continue;
            return i;
        }
        return data.length;
    }

    private static int indexOfNot(byte[] data, int fromIndex, byte key) {
        for (int i = fromIndex; i < data.length; ++i) {
            if (data[i] == key) continue;
            return i;
        }
        return data.length;
    }

    private static int parseId3Header(BitArray id3Buffer) throws ParserException {
        int id1 = id3Buffer.readUnsignedByte();
        int id2 = id3Buffer.readUnsignedByte();
        int id3 = id3Buffer.readUnsignedByte();
        if (id1 != 73 || id2 != 68 || id3 != 51) {
            throw new ParserException(String.format("Unexpected ID3 file identifier, expected \"ID3\", actual \"%c%c%c\".", id1, id2, id3));
        }
        id3Buffer.skipBytes(2);
        int flags = id3Buffer.readUnsignedByte();
        int id3Size = id3Buffer.readSynchSafeInt();
        if ((flags & 2) != 0) {
            int extendedHeaderSize = id3Buffer.readSynchSafeInt();
            if (extendedHeaderSize > 4) {
                id3Buffer.skipBytes(extendedHeaderSize - 4);
            }
            id3Size -= extendedHeaderSize;
        }
        if ((flags & 8) != 0) {
            id3Size -= 10;
        }
        return id3Size;
    }

    private static String getCharsetName(int encodingByte) {
        switch (encodingByte) {
            case 0: {
                return "ISO-8859-1";
            }
            case 1: {
                return "UTF-16";
            }
            case 2: {
                return "UTF-16BE";
            }
            case 3: {
                return "UTF-8";
            }
        }
        return "ISO-8859-1";
    }
}

