/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.annotation.SuppressLint;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.text.eia608.Eia608Parser;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.BitArray;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class TsExtractor {
    private static final String TAG = "TsExtractor";
    private static final int TS_PACKET_SIZE = 188;
    private static final int TS_SYNC_BYTE = 71;
    private static final int TS_PAT_PID = 0;
    private static final int TS_STREAM_TYPE_AAC = 15;
    private static final int TS_STREAM_TYPE_H264 = 27;
    private static final int TS_STREAM_TYPE_ID3 = 21;
    private static final int TS_STREAM_TYPE_EIA608 = 256;
    private final BitArray tsPacketBuffer;
    private final SparseArray<SampleQueue> sampleQueues;
    private final SparseArray<TsPayloadReader> tsPayloadReaders;
    private final SamplePool samplePool;
    private final boolean shouldSpliceIn;
    final long firstSampleTimestamp;
    private boolean spliceConfigured;
    boolean pendingFirstSampleTimestampAdjustment;
    long sampleTimestampOffsetUs;
    private volatile boolean prepared;
    volatile long largestParsedTimestampUs;

    public TsExtractor(long firstSampleTimestamp, SamplePool samplePool, boolean shouldSpliceIn) {
        this.firstSampleTimestamp = firstSampleTimestamp;
        this.samplePool = samplePool;
        this.shouldSpliceIn = shouldSpliceIn;
        this.pendingFirstSampleTimestampAdjustment = true;
        this.tsPacketBuffer = new BitArray();
        this.sampleQueues = new SparseArray();
        this.tsPayloadReaders = new SparseArray();
        this.tsPayloadReaders.put(0, (Object)new PatReader());
        this.largestParsedTimestampUs = Long.MIN_VALUE;
    }

    public int getTrackCount() {
        Assertions.checkState(this.prepared);
        return this.sampleQueues.size();
    }

    public MediaFormat getFormat(int track) {
        Assertions.checkState(this.prepared);
        return ((SampleQueue)this.sampleQueues.valueAt(track)).getMediaFormat();
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void release() {
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            ((SampleQueue)this.sampleQueues.valueAt(i)).release();
        }
    }

    public void configureSpliceTo(TsExtractor nextExtractor) {
        Assertions.checkState(this.prepared);
        if (this.spliceConfigured || !nextExtractor.shouldSpliceIn || !nextExtractor.isPrepared()) {
            return;
        }
        boolean spliceConfigured = true;
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            spliceConfigured &= ((SampleQueue)this.sampleQueues.valueAt(i)).configureSpliceTo((SampleQueue)nextExtractor.sampleQueues.valueAt(i));
        }
        this.spliceConfigured = spliceConfigured;
    }

    public long getLargestSampleTimestamp() {
        return this.largestParsedTimestampUs;
    }

    public boolean getSample(int track, SampleHolder out) {
        Assertions.checkState(this.prepared);
        SampleQueue sampleQueue = (SampleQueue)this.sampleQueues.valueAt(track);
        Sample sample = sampleQueue.poll();
        if (sample == null) {
            return false;
        }
        this.convert(sample, out);
        sampleQueue.recycle(sample);
        return true;
    }

    public void discardUntil(int track, long timeUs) {
        Assertions.checkState(this.prepared);
        ((SampleQueue)this.sampleQueues.valueAt(track)).discardUntil(timeUs);
    }

    public boolean hasSamples(int track) {
        Assertions.checkState(this.prepared);
        return ((SampleQueue)this.sampleQueues.valueAt(track)).peek() != null;
    }

    private boolean checkPrepared() {
        int pesPayloadReaderCount = this.sampleQueues.size();
        if (pesPayloadReaderCount == 0) {
            return false;
        }
        for (int i = 0; i < pesPayloadReaderCount; ++i) {
            if (((SampleQueue)this.sampleQueues.valueAt(i)).hasMediaFormat()) continue;
            return false;
        }
        return true;
    }

    public int read(DataSource dataSource) throws IOException {
        TsPayloadReader payloadReader;
        int read = this.tsPacketBuffer.append(dataSource, 188 - this.tsPacketBuffer.bytesLeft());
        if (read == -1) {
            return -1;
        }
        if (this.tsPacketBuffer.bytesLeft() != 188) {
            return read;
        }
        int syncByte = this.tsPacketBuffer.readUnsignedByte();
        if (syncByte != 71) {
            return read;
        }
        this.tsPacketBuffer.skipBits(1);
        boolean payloadUnitStartIndicator = this.tsPacketBuffer.readBit();
        this.tsPacketBuffer.skipBits(1);
        int pid = this.tsPacketBuffer.readBits(13);
        this.tsPacketBuffer.skipBits(2);
        boolean adaptationFieldExists = this.tsPacketBuffer.readBit();
        boolean payloadExists = this.tsPacketBuffer.readBit();
        this.tsPacketBuffer.skipBits(4);
        if (adaptationFieldExists) {
            int adaptationFieldLength = this.tsPacketBuffer.readBits(8);
            this.tsPacketBuffer.skipBytes(adaptationFieldLength);
        }
        if (payloadExists && (payloadReader = (TsPayloadReader)this.tsPayloadReaders.get(pid)) != null) {
            payloadReader.read(this.tsPacketBuffer, payloadUnitStartIndicator);
        }
        if (!this.prepared) {
            this.prepared = this.checkPrepared();
        }
        this.tsPacketBuffer.reset();
        return read;
    }

    @SuppressLint(value={"InlinedApi"})
    private void convert(Sample in, SampleHolder out) {
        if (out.data == null || out.data.capacity() < in.size) {
            out.replaceBuffer(in.size);
        }
        if (out.data != null) {
            out.data.put(in.data, 0, in.size);
        }
        out.size = in.size;
        out.flags = in.isKeyframe ? 1 : 0;
        out.timeUs = in.timeUs;
    }

    private static class Sample {
        public static final int TYPE_VIDEO = 0;
        public static final int TYPE_AUDIO = 1;
        public static final int TYPE_MISC = 2;
        public static final int TYPE_COUNT = 3;
        public final int type;
        public Sample nextInPool;
        public byte[] data;
        public boolean isKeyframe;
        public int size;
        public long timeUs;

        public Sample(int type, int length) {
            this.type = type;
            this.data = new byte[length];
        }

        public void expand(int length) {
            byte[] newBuffer = new byte[this.data.length + length];
            System.arraycopy(this.data, 0, newBuffer, 0, this.size);
            this.data = newBuffer;
        }

        public void reset() {
            this.isKeyframe = false;
            this.size = 0;
            this.timeUs = 0L;
        }
    }

    public static class SamplePool {
        private static final int[] DEFAULT_SAMPLE_SIZES = new int[3];
        private final Sample[] pools = new Sample[3];

        synchronized Sample get(int type) {
            if (this.pools[type] == null) {
                return new Sample(type, DEFAULT_SAMPLE_SIZES[type]);
            }
            Sample sample = this.pools[type];
            this.pools[type] = sample.nextInPool;
            sample.nextInPool = null;
            return sample;
        }

        synchronized void recycle(Sample sample) {
            sample.reset();
            sample.nextInPool = this.pools[sample.type];
            this.pools[sample.type] = sample;
        }

        static {
            SamplePool.DEFAULT_SAMPLE_SIZES[0] = 10240;
            SamplePool.DEFAULT_SAMPLE_SIZES[1] = 512;
            SamplePool.DEFAULT_SAMPLE_SIZES[2] = 512;
        }
    }

    private class Id3Reader
    extends PesPayloadReader {
        public Id3Reader(SamplePool samplePool) {
            super(samplePool);
            this.setMediaFormat(MediaFormat.createId3Format());
        }

        @Override
        @SuppressLint(value={"InlinedApi"})
        public void read(BitArray pesBuffer, int pesPayloadSize, long pesTimeUs) {
            this.addSample(2, pesBuffer, pesPayloadSize, pesTimeUs, true);
        }
    }

    private class AdtsReader
    extends PesPayloadReader {
        private final BitArray adtsBuffer;
        private long timeUs;
        private long frameDurationUs;

        public AdtsReader(SamplePool samplePool) {
            super(samplePool);
            this.adtsBuffer = new BitArray();
        }

        @Override
        public void read(BitArray pesBuffer, int pesPayloadSize, long pesTimeUs) {
            boolean needToProcessLeftOvers = !this.adtsBuffer.isEmpty();
            this.adtsBuffer.append(pesBuffer, pesPayloadSize);
            if (needToProcessLeftOvers && !this.readOneAacFrame(this.timeUs)) {
                return;
            }
            int frameIndex = 0;
            do {
                this.timeUs = pesTimeUs + this.frameDurationUs * (long)frameIndex++;
            } while (this.readOneAacFrame(this.timeUs));
        }

        @SuppressLint(value={"InlinedApi"})
        private boolean readOneAacFrame(long timeUs) {
            boolean hasCRC;
            if (this.adtsBuffer.isEmpty()) {
                return false;
            }
            int offsetToSyncWord = this.adtsBuffer.findNextAdtsSyncWord();
            this.adtsBuffer.skipBytes(offsetToSyncWord);
            int adtsStartOffset = this.adtsBuffer.getByteOffset();
            if (this.adtsBuffer.bytesLeft() < 7) {
                this.adtsBuffer.setByteOffset(adtsStartOffset);
                this.adtsBuffer.clearReadData();
                return false;
            }
            this.adtsBuffer.skipBits(15);
            boolean bl = hasCRC = !this.adtsBuffer.readBit();
            if (!this.hasMediaFormat()) {
                int audioObjectType = this.adtsBuffer.readBits(2) + 1;
                int sampleRateIndex = this.adtsBuffer.readBits(4);
                this.adtsBuffer.skipBits(1);
                int channelConfig = this.adtsBuffer.readBits(3);
                byte[] audioSpecificConfig = CodecSpecificDataUtil.buildAudioSpecificConfig(audioObjectType, sampleRateIndex, channelConfig);
                Pair<Integer, Integer> audioParams = CodecSpecificDataUtil.parseAudioSpecificConfig(audioSpecificConfig);
                MediaFormat mediaFormat = MediaFormat.createAudioFormat("audio/mp4a-latm", -1, (Integer)audioParams.second, (Integer)audioParams.first, Collections.singletonList(audioSpecificConfig));
                this.frameDurationUs = 1024000000L / (long)mediaFormat.sampleRate;
                this.setMediaFormat(mediaFormat);
            } else {
                this.adtsBuffer.skipBits(10);
            }
            this.adtsBuffer.skipBits(4);
            int frameSize = this.adtsBuffer.readBits(13);
            this.adtsBuffer.skipBits(13);
            if (hasCRC) {
                this.adtsBuffer.skipBytes(2);
                frameSize -= 9;
            } else {
                frameSize -= 7;
            }
            if (frameSize > this.adtsBuffer.bytesLeft()) {
                this.adtsBuffer.setByteOffset(adtsStartOffset);
                this.adtsBuffer.clearReadData();
                return false;
            }
            this.addSample(1, this.adtsBuffer, frameSize, timeUs, true);
            return true;
        }

        @Override
        public void release() {
            super.release();
            this.adtsBuffer.reset();
        }
    }

    private class SeiReader
    extends SampleQueue {
        private static final int NAL_UNIT_TYPE_SEI = 6;
        private final BitArray seiBuffer;

        public SeiReader(SamplePool samplePool) {
            super(samplePool);
            this.setMediaFormat(MediaFormat.createEia608Format());
            this.seiBuffer = new BitArray();
        }

        @SuppressLint(value={"InlinedApi"})
        public void read(byte[] data, int size, long pesTimeUs) {
            this.seiBuffer.reset(data, size);
            while (this.seiBuffer.bytesLeft() > 0) {
                int seiStart = this.seiBuffer.findNextNalUnit(6, 0);
                if (seiStart == this.seiBuffer.bytesLeft()) {
                    return;
                }
                this.seiBuffer.skipBytes(seiStart + 4);
                int ccDataSize = Eia608Parser.parseHeader(this.seiBuffer);
                if (ccDataSize <= 0) continue;
                this.addSample(2, this.seiBuffer, ccDataSize, pesTimeUs, true);
            }
        }
    }

    private class H264Reader
    extends PesPayloadReader {
        private static final int NAL_UNIT_TYPE_IDR = 5;
        private static final int NAL_UNIT_TYPE_SPS = 7;
        private static final int NAL_UNIT_TYPE_PPS = 8;
        private static final int NAL_UNIT_TYPE_AUD = 9;
        public final SeiReader seiReader;
        private Sample currentSample;

        public H264Reader(SamplePool samplePool, SeiReader seiReader) {
            super(samplePool);
            this.seiReader = seiReader;
        }

        @Override
        public void release() {
            super.release();
            if (this.currentSample != null) {
                this.recycle(this.currentSample);
                this.currentSample = null;
            }
        }

        @Override
        public void read(BitArray pesBuffer, int pesPayloadSize, long pesTimeUs) {
            if (pesBuffer.bytesLeft() <= 0 || (pesPayloadSize -= this.readOneH264Frame(pesBuffer, true)) <= 0) {
                return;
            }
            if (this.currentSample != null) {
                if (!this.hasMediaFormat() && this.currentSample.isKeyframe) {
                    this.parseMediaFormat(this.currentSample);
                }
                this.seiReader.read(this.currentSample.data, this.currentSample.size, this.currentSample.timeUs);
                this.addSample(this.currentSample);
            }
            this.currentSample = this.getSample(0);
            this.currentSample.timeUs = pesTimeUs;
            if ((pesPayloadSize -= this.readOneH264Frame(pesBuffer, false)) > 0) {
                Log.e((String)TsExtractor.TAG, (String)"PES packet contains more frame data than expected");
            }
        }

        @SuppressLint(value={"InlinedApi"})
        private int readOneH264Frame(BitArray pesBuffer, boolean remainderOnly) {
            int offset = remainderOnly ? 0 : 3;
            int audStart = pesBuffer.findNextNalUnit(9, offset);
            if (this.currentSample != null) {
                int idrStart = pesBuffer.findNextNalUnit(5, offset);
                if (idrStart < audStart) {
                    this.currentSample.isKeyframe = true;
                }
                this.addToSample(this.currentSample, pesBuffer, audStart);
            } else {
                pesBuffer.skipBytes(audStart);
            }
            return audStart;
        }

        private void parseMediaFormat(Sample sample) {
            BitArray bitArray = new BitArray(sample.data, sample.size);
            int spsOffset = bitArray.findNextNalUnit(7, 0);
            int ppsOffset = bitArray.findNextNalUnit(8, 0);
            if (spsOffset == bitArray.bytesLeft() || ppsOffset == bitArray.bytesLeft()) {
                return;
            }
            int spsLength = bitArray.findNextNalUnit(-1, spsOffset + 3) - spsOffset;
            int ppsLength = bitArray.findNextNalUnit(-1, ppsOffset + 3) - ppsOffset;
            byte[] spsData = new byte[spsLength];
            byte[] ppsData = new byte[ppsLength];
            System.arraycopy(bitArray.getData(), spsOffset, spsData, 0, spsLength);
            System.arraycopy(bitArray.getData(), ppsOffset, ppsData, 0, ppsLength);
            ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
            initializationData.add(spsData);
            initializationData.add(ppsData);
            byte[] unescapedSps = this.unescapeStream(spsData, 0, spsLength);
            bitArray.reset(unescapedSps, unescapedSps.length);
            bitArray.skipBytes(4);
            int profileIdc = bitArray.readBits(8);
            bitArray.skipBytes(2);
            bitArray.readUnsignedExpGolombCodedInt();
            int chromaFormatIdc = 1;
            if (profileIdc == 100 || profileIdc == 110 || profileIdc == 122 || profileIdc == 244 || profileIdc == 44 || profileIdc == 83 || profileIdc == 86 || profileIdc == 118 || profileIdc == 128 || profileIdc == 138) {
                chromaFormatIdc = bitArray.readUnsignedExpGolombCodedInt();
                if (chromaFormatIdc == 3) {
                    bitArray.skipBits(1);
                }
                bitArray.readUnsignedExpGolombCodedInt();
                bitArray.readUnsignedExpGolombCodedInt();
                bitArray.skipBits(1);
                boolean seqScalingMatrixPresentFlag = bitArray.readBit();
                if (seqScalingMatrixPresentFlag) {
                    int limit = chromaFormatIdc != 3 ? 8 : 12;
                    for (int i = 0; i < limit; ++i) {
                        boolean seqScalingListPresentFlag = bitArray.readBit();
                        if (!seqScalingListPresentFlag) continue;
                        this.skipScalingList(bitArray, i < 6 ? 16 : 64);
                    }
                }
            }
            bitArray.readUnsignedExpGolombCodedInt();
            long picOrderCntType = bitArray.readUnsignedExpGolombCodedInt();
            if (picOrderCntType == 0L) {
                bitArray.readUnsignedExpGolombCodedInt();
            } else if (picOrderCntType == 1L) {
                bitArray.skipBits(1);
                bitArray.readSignedExpGolombCodedInt();
                bitArray.readSignedExpGolombCodedInt();
                long numRefFramesInPicOrderCntCycle = bitArray.readUnsignedExpGolombCodedInt();
                int i = 0;
                while ((long)i < numRefFramesInPicOrderCntCycle) {
                    bitArray.readUnsignedExpGolombCodedInt();
                    ++i;
                }
            }
            bitArray.readUnsignedExpGolombCodedInt();
            bitArray.skipBits(1);
            int picWidthInMbs = bitArray.readUnsignedExpGolombCodedInt() + 1;
            int picHeightInMapUnits = bitArray.readUnsignedExpGolombCodedInt() + 1;
            boolean frameMbsOnlyFlag = bitArray.readBit();
            int frameHeightInMbs = (2 - (frameMbsOnlyFlag ? 1 : 0)) * picHeightInMapUnits;
            if (!frameMbsOnlyFlag) {
                bitArray.skipBits(1);
            }
            bitArray.skipBits(1);
            int frameWidth = picWidthInMbs * 16;
            int frameHeight = frameHeightInMbs * 16;
            boolean frameCroppingFlag = bitArray.readBit();
            if (frameCroppingFlag) {
                int cropUnitY;
                int cropUnitX;
                int frameCropLeftOffset = bitArray.readUnsignedExpGolombCodedInt();
                int frameCropRightOffset = bitArray.readUnsignedExpGolombCodedInt();
                int frameCropTopOffset = bitArray.readUnsignedExpGolombCodedInt();
                int frameCropBottomOffset = bitArray.readUnsignedExpGolombCodedInt();
                if (chromaFormatIdc == 0) {
                    cropUnitX = 1;
                    cropUnitY = 2 - (frameMbsOnlyFlag ? 1 : 0);
                } else {
                    int subWidthC = chromaFormatIdc == 3 ? 1 : 2;
                    int subHeightC = chromaFormatIdc == 1 ? 2 : 1;
                    cropUnitX = subWidthC;
                    cropUnitY = subHeightC * (2 - (frameMbsOnlyFlag ? 1 : 0));
                }
                frameWidth -= (frameCropLeftOffset + frameCropRightOffset) * cropUnitX;
                frameHeight -= (frameCropTopOffset + frameCropBottomOffset) * cropUnitY;
            }
            this.setMediaFormat(MediaFormat.createVideoFormat("video/avc", -1, frameWidth, frameHeight, initializationData));
        }

        private void skipScalingList(BitArray bitArray, int size) {
            int lastScale = 8;
            int nextScale = 8;
            for (int i = 0; i < size; ++i) {
                if (nextScale != 0) {
                    int deltaScale = bitArray.readSignedExpGolombCodedInt();
                    nextScale = (lastScale + deltaScale + 256) % 256;
                }
                lastScale = nextScale == 0 ? lastScale : nextScale;
            }
        }

        private byte[] unescapeStream(byte[] data, int offset, int limit) {
            int position = offset;
            ArrayList<Integer> escapePositions = new ArrayList<Integer>();
            while (position < limit) {
                if ((position = this.findNextUnescapeIndex(data, position, limit)) >= limit) continue;
                escapePositions.add(position);
                position += 3;
            }
            int escapeCount = escapePositions.size();
            int escapedPosition = offset;
            int unescapedPosition = 0;
            byte[] unescapedData = new byte[limit - offset - escapeCount];
            for (int i = 0; i < escapeCount; ++i) {
                int nextEscapePosition = (Integer)escapePositions.get(i);
                int copyLength = nextEscapePosition - escapedPosition;
                System.arraycopy(data, escapedPosition, unescapedData, unescapedPosition, copyLength);
                escapedPosition += copyLength + 3;
                unescapedPosition += copyLength + 2;
            }
            int remainingLength = unescapedData.length - unescapedPosition;
            System.arraycopy(data, escapedPosition, unescapedData, unescapedPosition, remainingLength);
            return unescapedData;
        }

        private int findNextUnescapeIndex(byte[] bytes, int offset, int limit) {
            for (int i = offset; i < limit - 2; ++i) {
                if (bytes[i] != 0 || bytes[i + 1] != 0 || bytes[i + 2] != 3) continue;
                return i;
            }
            return limit;
        }
    }

    private abstract class PesPayloadReader
    extends SampleQueue {
        protected PesPayloadReader(SamplePool samplePool) {
            super(samplePool);
        }

        public abstract void read(BitArray var1, int var2, long var3);
    }

    private abstract class SampleQueue {
        private final SamplePool samplePool;
        private final ConcurrentLinkedQueue<Sample> internalQueue;
        private boolean needKeyframe;
        private long lastReadTimeUs;
        private long spliceOutTimeUs;
        private volatile MediaFormat mediaFormat;

        protected SampleQueue(SamplePool samplePool) {
            this.samplePool = samplePool;
            this.internalQueue = new ConcurrentLinkedQueue();
            this.needKeyframe = true;
            this.lastReadTimeUs = Long.MIN_VALUE;
            this.spliceOutTimeUs = Long.MIN_VALUE;
        }

        public boolean hasMediaFormat() {
            return this.mediaFormat != null;
        }

        public MediaFormat getMediaFormat() {
            return this.mediaFormat;
        }

        protected void setMediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        public Sample poll() {
            Sample head = this.peek();
            if (head != null) {
                this.internalQueue.remove();
                this.needKeyframe = false;
                this.lastReadTimeUs = head.timeUs;
            }
            return head;
        }

        public Sample peek() {
            Sample head = this.internalQueue.peek();
            if (this.needKeyframe) {
                while (head != null && !head.isKeyframe) {
                    this.recycle(head);
                    this.internalQueue.remove();
                    head = this.internalQueue.peek();
                }
            }
            if (head == null) {
                return null;
            }
            if (this.spliceOutTimeUs != Long.MIN_VALUE && head.timeUs >= this.spliceOutTimeUs) {
                this.recycle(head);
                this.internalQueue.remove();
                return null;
            }
            return head;
        }

        public void discardUntil(long timeUs) {
            Sample head = this.peek();
            while (head != null && head.timeUs < timeUs) {
                this.recycle(head);
                this.internalQueue.remove();
                head = this.internalQueue.peek();
                this.needKeyframe = true;
            }
            this.lastReadTimeUs = Long.MIN_VALUE;
        }

        public void release() {
            Sample toRecycle = this.internalQueue.poll();
            while (toRecycle != null) {
                this.recycle(toRecycle);
                toRecycle = this.internalQueue.poll();
            }
        }

        public void recycle(Sample sample) {
            this.samplePool.recycle(sample);
        }

        public boolean configureSpliceTo(SampleQueue nextQueue) {
            if (this.spliceOutTimeUs != Long.MIN_VALUE) {
                return true;
            }
            Sample nextSample = this.internalQueue.peek();
            long firstPossibleSpliceTime = nextSample != null ? nextSample.timeUs : this.lastReadTimeUs + 1L;
            ConcurrentLinkedQueue<Sample> nextInternalQueue = nextQueue.internalQueue;
            Sample nextQueueSample = nextInternalQueue.peek();
            while (!(nextQueueSample == null || nextQueueSample.timeUs >= firstPossibleSpliceTime && nextQueueSample.isKeyframe)) {
                nextQueue.internalQueue.remove();
                nextQueueSample = nextQueue.internalQueue.peek();
            }
            if (nextQueueSample != null) {
                this.spliceOutTimeUs = nextQueueSample.timeUs;
                return true;
            }
            return false;
        }

        protected Sample getSample(int type) {
            return this.samplePool.get(type);
        }

        protected void addSample(int type, BitArray buffer, int sampleSize, long sampleTimeUs, boolean isKeyframe) {
            Sample sample = this.getSample(type);
            this.addToSample(sample, buffer, sampleSize);
            sample.isKeyframe = isKeyframe;
            sample.timeUs = sampleTimeUs;
            this.addSample(sample);
        }

        protected void addSample(Sample sample) {
            this.adjustTimestamp(sample);
            TsExtractor.this.largestParsedTimestampUs = Math.max(TsExtractor.this.largestParsedTimestampUs, sample.timeUs);
            this.internalQueue.add(sample);
        }

        protected void addToSample(Sample sample, BitArray buffer, int size) {
            if (sample.data.length - sample.size < size) {
                sample.expand(size - sample.data.length + sample.size);
            }
            buffer.readBytes(sample.data, sample.size, size);
            sample.size += size;
        }

        private void adjustTimestamp(Sample sample) {
            if (TsExtractor.this.pendingFirstSampleTimestampAdjustment) {
                TsExtractor.this.sampleTimestampOffsetUs = TsExtractor.this.firstSampleTimestamp - sample.timeUs;
                TsExtractor.this.pendingFirstSampleTimestampAdjustment = false;
            }
            sample.timeUs += TsExtractor.this.sampleTimestampOffsetUs;
        }
    }

    private class PesReader
    extends TsPayloadReader {
        private final BitArray pesBuffer;
        private final PesPayloadReader pesPayloadReader;
        private int packetLength;

        public PesReader(PesPayloadReader pesPayloadReader) {
            this.pesPayloadReader = pesPayloadReader;
            this.packetLength = -1;
            this.pesBuffer = new BitArray();
        }

        @Override
        public void read(BitArray tsBuffer, boolean payloadUnitStartIndicator) {
            if (payloadUnitStartIndicator && !this.pesBuffer.isEmpty()) {
                if (this.packetLength == 0) {
                    this.readPacketBody();
                } else {
                    Log.w((String)TsExtractor.TAG, (String)("Unexpected packet fragment of length " + this.pesBuffer.bytesLeft()));
                    this.pesBuffer.reset();
                    this.packetLength = -1;
                }
            }
            this.pesBuffer.append(tsBuffer, tsBuffer.bytesLeft());
            if (this.packetLength == -1 && this.pesBuffer.bytesLeft() >= 6) {
                this.readPacketStart();
            }
            if (this.packetLength > 0 && this.pesBuffer.bytesLeft() >= this.packetLength) {
                this.readPacketBody();
            }
        }

        private void readPacketStart() {
            int startCodePrefix = this.pesBuffer.readBits(24);
            if (startCodePrefix != 1) {
                Log.w((String)TsExtractor.TAG, (String)("Unexpected start code prefix: " + startCodePrefix));
                this.pesBuffer.reset();
                this.packetLength = -1;
            } else {
                this.pesBuffer.skipBits(8);
                this.packetLength = this.pesBuffer.readBits(16);
            }
        }

        private void readPacketBody() {
            this.pesBuffer.skipBits(8);
            boolean ptsFlag = this.pesBuffer.readBit();
            this.pesBuffer.skipBits(1);
            this.pesBuffer.skipBits(6);
            int headerDataLength = this.pesBuffer.readBits(8);
            if (headerDataLength == 0) {
                headerDataLength = this.pesBuffer.bytesLeft();
            }
            long timeUs = 0L;
            if (ptsFlag) {
                this.pesBuffer.skipBits(4);
                long pts = this.pesBuffer.readBitsLong(3) << 30;
                this.pesBuffer.skipBits(1);
                pts |= this.pesBuffer.readBitsLong(15) << 15;
                this.pesBuffer.skipBits(1);
                this.pesBuffer.skipBits(1);
                timeUs = (pts |= this.pesBuffer.readBitsLong(15)) * 1000000L / 90000L;
                this.pesBuffer.skipBytes(headerDataLength - 5);
            } else {
                this.pesBuffer.skipBytes(headerDataLength);
            }
            int payloadSize = this.packetLength == 0 ? this.pesBuffer.bytesLeft() : this.packetLength - headerDataLength - 3;
            this.pesPayloadReader.read(this.pesBuffer, payloadSize, timeUs);
            this.pesBuffer.reset();
            this.packetLength = -1;
        }
    }

    private class PmtReader
    extends TsPayloadReader {
        private PmtReader() {
        }

        @Override
        public void read(BitArray tsBuffer, boolean payloadUnitStartIndicator) {
            if (payloadUnitStartIndicator) {
                int pointerField = tsBuffer.readBits(8);
                tsBuffer.skipBytes(pointerField);
            }
            tsBuffer.skipBits(12);
            int sectionLength = tsBuffer.readBits(12);
            tsBuffer.skipBits(60);
            int programInfoLength = tsBuffer.readBits(12);
            tsBuffer.skipBytes(programInfoLength);
            int entriesSize = sectionLength - 9 - programInfoLength - 4;
            while (entriesSize > 0) {
                int streamType = tsBuffer.readBits(8);
                tsBuffer.skipBits(3);
                int elementaryPid = tsBuffer.readBits(13);
                tsBuffer.skipBits(4);
                int esInfoLength = tsBuffer.readBits(12);
                tsBuffer.skipBytes(esInfoLength);
                entriesSize -= esInfoLength + 5;
                if (TsExtractor.this.sampleQueues.get(streamType) != null) continue;
                PesPayloadReader pesPayloadReader = null;
                switch (streamType) {
                    case 15: {
                        pesPayloadReader = new AdtsReader(TsExtractor.this.samplePool);
                        break;
                    }
                    case 27: {
                        SeiReader seiReader = new SeiReader(TsExtractor.this.samplePool);
                        TsExtractor.this.sampleQueues.put(256, (Object)seiReader);
                        pesPayloadReader = new H264Reader(TsExtractor.this.samplePool, seiReader);
                        break;
                    }
                    case 21: {
                        pesPayloadReader = new Id3Reader(TsExtractor.this.samplePool);
                    }
                }
                if (pesPayloadReader == null) continue;
                TsExtractor.this.sampleQueues.put(streamType, pesPayloadReader);
                TsExtractor.this.tsPayloadReaders.put(elementaryPid, (Object)new PesReader(pesPayloadReader));
            }
        }
    }

    private class PatReader
    extends TsPayloadReader {
        private PatReader() {
        }

        @Override
        public void read(BitArray tsBuffer, boolean payloadUnitStartIndicator) {
            if (payloadUnitStartIndicator) {
                int pointerField = tsBuffer.readBits(8);
                tsBuffer.skipBytes(pointerField);
            }
            tsBuffer.skipBits(12);
            int sectionLength = tsBuffer.readBits(12);
            tsBuffer.skipBits(40);
            int programCount = (sectionLength - 9) / 4;
            for (int i = 0; i < programCount; ++i) {
                tsBuffer.skipBits(19);
                int pid = tsBuffer.readBits(13);
                TsExtractor.this.tsPayloadReaders.put(pid, (Object)new PmtReader());
            }
        }
    }

    private static abstract class TsPayloadReader {
        private TsPayloadReader() {
        }

        public abstract void read(BitArray var1, boolean var2);
    }
}

