/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.hls.HlsChunk;
import com.google.android.exoplayer.hls.TsExtractor;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import java.io.IOException;

public final class TsChunk
extends HlsChunk {
    private static final byte[] SCRATCH_SPACE = new byte[4096];
    public final int variantIndex;
    public final long startTimeUs;
    public final long endTimeUs;
    public final int chunkIndex;
    public final boolean isLastChunk;
    public final TsExtractor extractor;
    private int loadPosition;
    private volatile boolean loadFinished;
    private volatile boolean loadCanceled;

    public TsChunk(DataSource dataSource, DataSpec dataSpec, TsExtractor tsExtractor, int variantIndex, long startTimeUs, long endTimeUs, int chunkIndex, boolean isLastChunk) {
        super(dataSource, dataSpec);
        this.extractor = tsExtractor;
        this.variantIndex = variantIndex;
        this.startTimeUs = startTimeUs;
        this.endTimeUs = endTimeUs;
        this.chunkIndex = chunkIndex;
        this.isLastChunk = isLastChunk;
    }

    @Override
    public void consume() throws IOException {
    }

    @Override
    public boolean isLoadFinished() {
        return this.loadFinished;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        try {
            this.dataSource.open(this.dataSpec);
            int bytesRead = 0;
            int bytesSkipped = 0;
            while (bytesRead != -1 && !this.loadCanceled && bytesSkipped < this.loadPosition) {
                int skipLength = Math.min(this.loadPosition - bytesSkipped, SCRATCH_SPACE.length);
                bytesRead = this.dataSource.read(SCRATCH_SPACE, 0, skipLength);
                if (bytesRead == -1) continue;
                bytesSkipped += bytesRead;
            }
            while (bytesRead != -1 && !this.loadCanceled) {
                bytesRead = this.extractor.read(this.dataSource);
                if (bytesRead == -1) continue;
                this.loadPosition += bytesRead;
            }
            this.loadFinished = !this.loadCanceled;
        }
        finally {
            this.dataSource.close();
        }
    }
}

