/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.net.Uri;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsMediaPlaylist;
import com.google.android.exoplayer.hls.HlsParserUtil;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.Variant;
import com.google.android.exoplayer.util.ManifestParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Pattern;

public final class HlsPlaylistParser
implements ManifestParser<HlsPlaylist> {
    private static final String VERSION_TAG = "#EXT-X-VERSION";
    private static final String STREAM_INF_TAG = "#EXT-X-STREAM-INF";
    private static final String BANDWIDTH_ATTR = "BANDWIDTH";
    private static final String CODECS_ATTR = "CODECS";
    private static final String RESOLUTION_ATTR = "RESOLUTION";
    private static final String DISCONTINUITY_TAG = "#EXT-X-DISCONTINUITY";
    private static final String MEDIA_DURATION_TAG = "#EXTINF";
    private static final String MEDIA_SEQUENCE_TAG = "#EXT-X-MEDIA-SEQUENCE";
    private static final String TARGET_DURATION_TAG = "#EXT-X-TARGETDURATION";
    private static final String ENDLIST_TAG = "#EXT-X-ENDLIST";
    private static final String KEY_TAG = "#EXT-X-KEY";
    private static final String BYTERANGE_TAG = "#EXT-X-BYTERANGE";
    private static final String METHOD_ATTR = "METHOD";
    private static final String URI_ATTR = "URI";
    private static final String IV_ATTR = "IV";
    private static final Pattern BANDWIDTH_ATTR_REGEX = Pattern.compile("BANDWIDTH=(\\d+)\\b");
    private static final Pattern CODECS_ATTR_REGEX = Pattern.compile("CODECS=\"(.+)\"");
    private static final Pattern RESOLUTION_ATTR_REGEX = Pattern.compile("RESOLUTION=(\\d+x\\d+)");
    private static final Pattern MEDIA_DURATION_REGEX = Pattern.compile("#EXTINF:([\\d.]+),");
    private static final Pattern MEDIA_SEQUENCE_REGEX = Pattern.compile("#EXT-X-MEDIA-SEQUENCE:(\\d+)\\b");
    private static final Pattern TARGET_DURATION_REGEX = Pattern.compile("#EXT-X-TARGETDURATION:(\\d+)\\b");
    private static final Pattern VERSION_REGEX = Pattern.compile("#EXT-X-VERSION:(\\d+)\\b");
    private static final Pattern BYTERANGE_REGEX = Pattern.compile("#EXT-X-BYTERANGE:(\\d+(?:@\\d+)?)\\b");
    private static final Pattern METHOD_ATTR_REGEX = Pattern.compile("METHOD=([^,.*]+)");
    private static final Pattern URI_ATTR_REGEX = Pattern.compile("URI=\"(.+)\"");
    private static final Pattern IV_ATTR_REGEX = Pattern.compile("IV=([^,.*]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HlsPlaylist parse(InputStream inputStream, String inputEncoding, String contentId, Uri baseUri) throws IOException {
        LinkedList<String> extraLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(inputEncoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, inputEncoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(STREAM_INF_TAG)) {
                    extraLines.add(line);
                    HlsMasterPlaylist hlsMasterPlaylist = HlsPlaylistParser.parseMasterPlaylist(new LineIterator(extraLines, reader), baseUri);
                    return hlsMasterPlaylist;
                }
                if (line.startsWith(TARGET_DURATION_TAG) || line.startsWith(MEDIA_SEQUENCE_TAG) || line.startsWith(MEDIA_DURATION_TAG) || line.startsWith(KEY_TAG) || line.startsWith(BYTERANGE_TAG) || line.equals(DISCONTINUITY_TAG) || line.equals(ENDLIST_TAG)) {
                    extraLines.add(line);
                    HlsMediaPlaylist hlsMediaPlaylist = HlsPlaylistParser.parseMediaPlaylist(new LineIterator(extraLines, reader), baseUri);
                    return hlsMediaPlaylist;
                }
                if (line.startsWith(VERSION_TAG)) {
                    extraLines.add(line);
                    continue;
                }
                if (line.startsWith("#")) continue;
                throw new ParserException("Missing a tag before URL.");
            }
        }
        throw new ParserException("Failed to parse the playlist, could not identify any tags.");
    }

    private static HlsMasterPlaylist parseMasterPlaylist(LineIterator iterator, Uri baseUri) throws IOException {
        ArrayList<Variant> variants = new ArrayList<Variant>();
        int bandwidth = 0;
        String[] codecs = null;
        int width = -1;
        int height = -1;
        int variantIndex = 0;
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (line.startsWith(STREAM_INF_TAG)) {
                bandwidth = HlsParserUtil.parseIntAttr(line, BANDWIDTH_ATTR_REGEX, BANDWIDTH_ATTR);
                String codecsString = HlsParserUtil.parseOptionalStringAttr(line, CODECS_ATTR_REGEX);
                codecs = codecsString != null ? codecsString.split("(\\s*,\\s*)|(\\s*$)") : null;
                String resolutionString = HlsParserUtil.parseOptionalStringAttr(line, RESOLUTION_ATTR_REGEX);
                if (resolutionString != null) {
                    String[] widthAndHeight = resolutionString.split("x");
                    width = Integer.parseInt(widthAndHeight[0]);
                    height = Integer.parseInt(widthAndHeight[1]);
                    continue;
                }
                width = -1;
                height = -1;
                continue;
            }
            if (line.startsWith("#")) continue;
            variants.add(new Variant(variantIndex++, line, bandwidth, codecs, width, height));
            bandwidth = 0;
            codecs = null;
            width = -1;
            height = -1;
        }
        return new HlsMasterPlaylist(baseUri, Collections.unmodifiableList(variants));
    }

    private static HlsMediaPlaylist parseMediaPlaylist(LineIterator iterator, Uri baseUri) throws IOException {
        int mediaSequence = 0;
        int targetDurationSecs = 0;
        int version = 1;
        boolean live = true;
        ArrayList<HlsMediaPlaylist.Segment> segments = new ArrayList<HlsMediaPlaylist.Segment>();
        double segmentDurationSecs = 0.0;
        boolean segmentDiscontinuity = false;
        long segmentStartTimeUs = 0L;
        String segmentEncryptionMethod = null;
        String segmentEncryptionKeyUri = null;
        String segmentEncryptionIV = null;
        int segmentByterangeOffset = 0;
        int segmentByterangeLength = -1;
        int segmentMediaSequence = 0;
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (line.startsWith(TARGET_DURATION_TAG)) {
                targetDurationSecs = HlsParserUtil.parseIntAttr(line, TARGET_DURATION_REGEX, TARGET_DURATION_TAG);
                continue;
            }
            if (line.startsWith(MEDIA_SEQUENCE_TAG)) {
                segmentMediaSequence = mediaSequence = HlsParserUtil.parseIntAttr(line, MEDIA_SEQUENCE_REGEX, MEDIA_SEQUENCE_TAG);
                continue;
            }
            if (line.startsWith(VERSION_TAG)) {
                version = HlsParserUtil.parseIntAttr(line, VERSION_REGEX, VERSION_TAG);
                continue;
            }
            if (line.startsWith(MEDIA_DURATION_TAG)) {
                segmentDurationSecs = HlsParserUtil.parseDoubleAttr(line, MEDIA_DURATION_REGEX, MEDIA_DURATION_TAG);
                continue;
            }
            if (line.startsWith(KEY_TAG)) {
                segmentEncryptionMethod = HlsParserUtil.parseStringAttr(line, METHOD_ATTR_REGEX, METHOD_ATTR);
                if (segmentEncryptionMethod.equals("NONE")) {
                    segmentEncryptionKeyUri = null;
                    segmentEncryptionIV = null;
                    continue;
                }
                segmentEncryptionKeyUri = HlsParserUtil.parseStringAttr(line, URI_ATTR_REGEX, URI_ATTR);
                segmentEncryptionIV = HlsParserUtil.parseOptionalStringAttr(line, IV_ATTR_REGEX);
                if (segmentEncryptionIV != null) continue;
                segmentEncryptionIV = Integer.toHexString(segmentMediaSequence);
                continue;
            }
            if (line.startsWith(BYTERANGE_TAG)) {
                String byteRange = HlsParserUtil.parseStringAttr(line, BYTERANGE_REGEX, BYTERANGE_TAG);
                String[] splitByteRange = byteRange.split("@");
                segmentByterangeLength = Integer.parseInt(splitByteRange[0]);
                if (splitByteRange.length <= 1) continue;
                segmentByterangeOffset = Integer.parseInt(splitByteRange[1]);
                continue;
            }
            if (line.equals(DISCONTINUITY_TAG)) {
                segmentDiscontinuity = true;
                continue;
            }
            if (!line.startsWith("#")) {
                ++segmentMediaSequence;
                if (segmentByterangeLength == -1) {
                    segmentByterangeOffset = 0;
                }
                segments.add(new HlsMediaPlaylist.Segment(line, segmentDurationSecs, segmentDiscontinuity, segmentStartTimeUs, segmentEncryptionMethod, segmentEncryptionKeyUri, segmentEncryptionIV, segmentByterangeOffset, segmentByterangeLength));
                segmentStartTimeUs += (long)(segmentDurationSecs * 1000000.0);
                segmentDiscontinuity = false;
                segmentDurationSecs = 0.0;
                if (segmentByterangeLength != -1) {
                    segmentByterangeOffset += segmentByterangeLength;
                }
                segmentByterangeLength = -1;
                continue;
            }
            if (!line.equals(ENDLIST_TAG)) continue;
            live = false;
            break;
        }
        return new HlsMediaPlaylist(baseUri, mediaSequence, targetDurationSecs, version, live, Collections.unmodifiableList(segments));
    }

    private static class LineIterator {
        private final BufferedReader reader;
        private final Queue<String> extraLines;
        private String next;

        public LineIterator(Queue<String> extraLines, BufferedReader reader) {
            this.extraLines = extraLines;
            this.reader = reader;
        }

        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            if (!this.extraLines.isEmpty()) {
                this.next = this.extraLines.poll();
                return true;
            }
            while ((this.next = this.reader.readLine()) != null) {
                this.next = this.next.trim();
                if (this.next.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String next() throws IOException {
            String result = null;
            if (this.hasNext()) {
                result = this.next;
                this.next = null;
            }
            return result;
        }
    }
}

