/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.ParserException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HlsParserUtil {
    private HlsParserUtil() {
    }

    public static String parseStringAttr(String line, Pattern pattern, String tag) throws ParserException {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new ParserException(String.format("Couldn't match %s tag in %s", tag, line));
    }

    public static String parseOptionalStringAttr(String line, Pattern pattern) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    public static int parseIntAttr(String line, Pattern pattern, String tag) throws ParserException {
        return Integer.parseInt(HlsParserUtil.parseStringAttr(line, pattern, tag));
    }

    public static double parseDoubleAttr(String line, Pattern pattern, String tag) throws ParserException {
        return Double.parseDouble(HlsParserUtil.parseStringAttr(line, pattern, tag));
    }
}

