/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.net.Uri;
import com.google.android.exoplayer.hls.HlsPlaylist;
import java.util.List;

public final class HlsMediaPlaylist
extends HlsPlaylist {
    public static final String ENCRYPTION_METHOD_NONE = "NONE";
    public static final String ENCRYPTION_METHOD_AES_128 = "AES-128";
    public final int mediaSequence;
    public final int targetDurationSecs;
    public final int version;
    public final List<Segment> segments;
    public final boolean live;
    public final long durationUs;

    public HlsMediaPlaylist(Uri baseUri, int mediaSequence, int targetDurationSecs, int version, boolean live, List<Segment> segments) {
        super(baseUri, 1);
        this.mediaSequence = mediaSequence;
        this.targetDurationSecs = targetDurationSecs;
        this.version = version;
        this.live = live;
        this.segments = segments;
        if (!segments.isEmpty()) {
            Segment last = segments.get(segments.size() - 1);
            this.durationUs = last.startTimeUs + (long)(last.durationSecs * 1000000.0);
        } else {
            this.durationUs = 0L;
        }
    }

    public static final class Segment
    implements Comparable<Long> {
        public final boolean discontinuity;
        public final double durationSecs;
        public final String url;
        public final long startTimeUs;
        public final String encryptionMethod;
        public final String encryptionKeyUri;
        public final String encryptionIV;
        public final int byterangeOffset;
        public final int byterangeLength;

        public Segment(String uri, double durationSecs, boolean discontinuity, long startTimeUs, String encryptionMethod, String encryptionKeyUri, String encryptionIV, int byterangeOffset, int byterangeLength) {
            this.url = uri;
            this.durationSecs = durationSecs;
            this.discontinuity = discontinuity;
            this.startTimeUs = startTimeUs;
            this.encryptionMethod = encryptionMethod;
            this.encryptionKeyUri = encryptionKeyUri;
            this.encryptionIV = encryptionIV;
            this.byterangeOffset = byterangeOffset;
            this.byterangeLength = byterangeLength;
        }

        @Override
        public int compareTo(Long startTimeUs) {
            return this.startTimeUs > startTimeUs ? 1 : (this.startTimeUs < startTimeUs ? -1 : 0);
        }
    }
}

