/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.hls.HlsChunk;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.BitArray;
import java.io.IOException;

public abstract class BitArrayChunk
extends HlsChunk {
    private static final int READ_GRANULARITY = 16384;
    private final BitArray bitArray;
    private volatile boolean loadFinished;
    private volatile boolean loadCanceled;

    public BitArrayChunk(DataSource dataSource, DataSpec dataSpec, BitArray bitArray) {
        super(dataSource, dataSpec);
        this.bitArray = bitArray;
    }

    @Override
    public void consume() throws IOException {
        this.consume(this.bitArray);
    }

    protected abstract void consume(BitArray var1) throws IOException;

    @Override
    public boolean isLoadFinished() {
        return this.loadFinished;
    }

    @Override
    public final void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public final boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void load() throws IOException, InterruptedException {
        try {
            this.bitArray.reset();
            this.dataSource.open(this.dataSpec);
            int bytesRead = 0;
            while (bytesRead != -1 && !this.loadCanceled) {
                bytesRead = this.bitArray.append(this.dataSource, 16384);
            }
            this.loadFinished = !this.loadCanceled;
        }
        finally {
            this.dataSource.close();
        }
    }
}

