/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.util.Assertions;
import java.util.Map;
import java.util.UUID;

public class SingleSampleMediaChunk
extends MediaChunk {
    public final byte[] headerData;
    private final MediaFormat sampleFormat;

    public SingleSampleMediaChunk(DataSource dataSource, DataSpec dataSpec, Format format, int trigger, long startTimeUs, long endTimeUs, int nextChunkIndex, MediaFormat sampleFormat) {
        this(dataSource, dataSpec, format, trigger, startTimeUs, endTimeUs, nextChunkIndex, sampleFormat, null);
    }

    public SingleSampleMediaChunk(DataSource dataSource, DataSpec dataSpec, Format format, int trigger, long startTimeUs, long endTimeUs, int nextChunkIndex, MediaFormat sampleFormat, byte[] headerData) {
        super(dataSource, dataSpec, format, trigger, startTimeUs, endTimeUs, nextChunkIndex);
        this.sampleFormat = sampleFormat;
        this.headerData = headerData;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean sampleAvailable() {
        return this.isLoadFinished() && !this.isReadFinished();
    }

    @Override
    public boolean read(SampleHolder holder) {
        int bytesRead;
        int bytesLoaded;
        NonBlockingInputStream inputStream = this.getNonBlockingInputStream();
        Assertions.checkState(inputStream != null);
        if (!this.sampleAvailable()) {
            return false;
        }
        int sampleSize = bytesLoaded = (int)this.bytesLoaded();
        if (this.headerData != null) {
            sampleSize += this.headerData.length;
        }
        if (holder.data == null || holder.data.capacity() < sampleSize) {
            holder.replaceBuffer(sampleSize);
        }
        if (holder.data != null) {
            if (this.headerData != null) {
                holder.data.put(this.headerData);
            }
            bytesRead = inputStream.read(holder.data, bytesLoaded);
            holder.size = sampleSize;
        } else {
            bytesRead = inputStream.skip(bytesLoaded);
            holder.size = 0;
        }
        Assertions.checkState(bytesRead == bytesLoaded);
        holder.timeUs = this.startTimeUs;
        return true;
    }

    @Override
    public void seekToStart() {
        this.resetReadPosition();
    }

    @Override
    public boolean seekTo(long positionUs, boolean allowNoop) {
        this.resetReadPosition();
        return true;
    }

    @Override
    public MediaFormat getMediaFormat() {
        return this.sampleFormat;
    }

    @Override
    public Map<UUID, byte[]> getPsshInfo() {
        return null;
    }
}

