/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.audio;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.AudioTimestamp;
import android.media.MediaFormat;
import android.os.ConditionVariable;
import android.util.Log;
import com.google.android.exoplayer.util.Util;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public final class AudioTrack {
    public static final int RESULT_POSITION_DISCONTINUITY = 1;
    public static final int RESULT_BUFFER_CONSUMED = 2;
    public static final int SESSION_ID_NOT_SET = 0;
    public static final long CURRENT_POSITION_NOT_SET = Long.MIN_VALUE;
    private static final long MIN_BUFFER_DURATION_US = 250000L;
    private static final long MAX_BUFFER_DURATION_US = 750000L;
    private static final int BUFFER_MULTIPLICATION_FACTOR = 4;
    private static final String TAG = "AudioTrack";
    private static final long MAX_AUDIO_TIMESTAMP_OFFSET_US = 5000000L;
    private static final long MAX_LATENCY_US = 5000000L;
    private static final int UNKNOWN_AC3_BITRATE = 0;
    private static final int START_NOT_SET = 0;
    private static final int START_IN_SYNC = 1;
    private static final int START_NEED_SYNC = 2;
    private static final int MAX_PLAYHEAD_OFFSET_COUNT = 10;
    private static final int MIN_PLAYHEAD_OFFSET_SAMPLE_INTERVAL_US = 30000;
    private static final int MIN_TIMESTAMP_SAMPLE_INTERVAL_US = 500000;
    private final ConditionVariable releasingConditionVariable = new ConditionVariable(true);
    private final long[] playheadOffsets;
    private android.media.AudioTrack audioTrack;
    private AudioTrackUtil audioTrackUtil;
    private int sampleRate;
    private int channelConfig;
    private int encoding;
    private int frameSize;
    private int minBufferSize;
    private int bufferSize;
    private int nextPlayheadOffsetIndex;
    private int playheadOffsetCount;
    private long smoothedPlayheadOffsetUs;
    private long lastPlayheadSampleTimeUs;
    private boolean audioTimestampSet;
    private long lastTimestampSampleTimeUs;
    private Method getLatencyMethod;
    private long submittedBytes;
    private int startMediaTimeState;
    private long startMediaTimeUs;
    private long resumeSystemTimeUs;
    private long latencyUs;
    private float volume;
    private byte[] temporaryBuffer;
    private int temporaryBufferOffset;
    private int temporaryBufferSize;
    private boolean isAc3;
    private int ac3Bitrate;

    public AudioTrack() {
        if (Util.SDK_INT >= 18) {
            try {
                this.getLatencyMethod = android.media.AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.playheadOffsets = new long[10];
        this.volume = 1.0f;
        this.startMediaTimeState = 0;
    }

    public boolean isInitialized() {
        return this.audioTrack != null;
    }

    public long getCurrentPositionUs(boolean sourceEnded) {
        long currentPositionUs;
        if (!this.hasCurrentPositionUs()) {
            return Long.MIN_VALUE;
        }
        if (this.audioTrack.getPlayState() == 3) {
            this.maybeSampleSyncParams();
        }
        long systemClockUs = System.nanoTime() / 1000L;
        if (this.audioTimestampSet) {
            long presentationDiff = systemClockUs - this.audioTrackUtil.getTimestampNanoTime() / 1000L;
            long framesDiff = this.durationUsToFrames(presentationDiff);
            long currentFramePosition = this.audioTrackUtil.getTimestampFramePosition() + framesDiff;
            currentPositionUs = this.framesToDurationUs(currentFramePosition) + this.startMediaTimeUs;
        } else {
            currentPositionUs = this.playheadOffsetCount == 0 ? this.audioTrackUtil.getPlaybackHeadPositionUs() + this.startMediaTimeUs : systemClockUs + this.smoothedPlayheadOffsetUs + this.startMediaTimeUs;
            if (!sourceEnded) {
                currentPositionUs -= this.latencyUs;
            }
        }
        return currentPositionUs;
    }

    public int initialize() throws InitializationException {
        return this.initialize(0);
    }

    public int initialize(int sessionId) throws InitializationException {
        this.releasingConditionVariable.block();
        this.audioTrack = sessionId == 0 ? new android.media.AudioTrack(3, this.sampleRate, this.channelConfig, this.encoding, this.bufferSize, 1) : new android.media.AudioTrack(3, this.sampleRate, this.channelConfig, this.encoding, this.bufferSize, 1, sessionId);
        this.checkAudioTrackInitialized();
        this.audioTrackUtil = Util.SDK_INT >= 19 ? new AudioTrackUtilV19(this.audioTrack) : new AudioTrackUtil(this.audioTrack);
        this.setVolume(this.volume);
        return this.audioTrack.getAudioSessionId();
    }

    public void reconfigure(MediaFormat format) {
        this.reconfigure(format, 2, 0);
    }

    @SuppressLint(value={"InlinedApi"})
    public void reconfigure(MediaFormat format, int encoding, int specifiedBufferSize) {
        boolean isAc3;
        int channelConfig;
        int channelCount = format.getInteger("channel-count");
        switch (channelCount) {
            case 1: {
                channelConfig = 4;
                break;
            }
            case 2: {
                channelConfig = 12;
                break;
            }
            case 6: {
                channelConfig = 252;
                break;
            }
            case 8: {
                channelConfig = 1020;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel count: " + channelCount);
            }
        }
        int sampleRate = format.getInteger("sample-rate");
        boolean bl = isAc3 = encoding == 5 || encoding == 6;
        if (this.isInitialized() && this.sampleRate == sampleRate && this.channelConfig == channelConfig && !this.isAc3 && !isAc3) {
            return;
        }
        this.reset();
        this.encoding = encoding;
        this.sampleRate = sampleRate;
        this.channelConfig = channelConfig;
        this.isAc3 = isAc3;
        this.ac3Bitrate = 0;
        this.frameSize = 2 * channelCount;
        this.minBufferSize = android.media.AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)encoding);
        if (specifiedBufferSize != 0) {
            this.bufferSize = specifiedBufferSize;
        } else {
            int multipliedBufferSize = this.minBufferSize * 4;
            int minAppBufferSize = (int)this.durationUsToFrames(250000L) * this.frameSize;
            int maxAppBufferSize = (int)Math.max((long)this.minBufferSize, this.durationUsToFrames(750000L) * (long)this.frameSize);
            this.bufferSize = multipliedBufferSize < minAppBufferSize ? minAppBufferSize : (multipliedBufferSize > maxAppBufferSize ? maxAppBufferSize : multipliedBufferSize);
        }
    }

    public void play() {
        if (this.isInitialized()) {
            this.resumeSystemTimeUs = System.nanoTime() / 1000L;
            this.audioTrack.play();
        }
    }

    public void handleDiscontinuity() {
        if (this.startMediaTimeState == 1) {
            this.startMediaTimeState = 2;
        }
    }

    public int handleBuffer(ByteBuffer buffer, int offset, int size, long presentationTimeUs) throws WriteException {
        if (size == 0) {
            return 2;
        }
        int result = 0;
        if (this.temporaryBufferSize == 0) {
            if (this.isAc3 && this.ac3Bitrate == 0) {
                int unscaledAc3Bitrate = size * 8 * this.sampleRate;
                int divisor = 0x177000;
                this.ac3Bitrate = (unscaledAc3Bitrate + divisor / 2) / divisor;
            }
            long bufferStartTime = presentationTimeUs - this.framesToDurationUs(this.bytesToFrames(size));
            if (this.startMediaTimeUs == 0L) {
                this.startMediaTimeUs = Math.max(0L, bufferStartTime);
                this.startMediaTimeState = 1;
            } else {
                long expectedBufferStartTime = this.startMediaTimeUs + this.framesToDurationUs(this.bytesToFrames(this.submittedBytes));
                if (this.startMediaTimeState == 1 && Math.abs(expectedBufferStartTime - bufferStartTime) > 200000L) {
                    Log.e((String)TAG, (String)("Discontinuity detected [expected " + expectedBufferStartTime + ", got " + bufferStartTime + "]"));
                    this.startMediaTimeState = 2;
                }
                if (this.startMediaTimeState == 2) {
                    this.startMediaTimeUs += bufferStartTime - expectedBufferStartTime;
                    this.startMediaTimeState = 1;
                    result |= 1;
                }
            }
        }
        if (this.temporaryBufferSize == 0) {
            this.temporaryBufferSize = size;
            buffer.position(offset);
            if (Util.SDK_INT < 21) {
                if (this.temporaryBuffer == null || this.temporaryBuffer.length < size) {
                    this.temporaryBuffer = new byte[size];
                }
                buffer.get(this.temporaryBuffer, 0, size);
                this.temporaryBufferOffset = 0;
            }
        }
        int bytesWritten = 0;
        if (Util.SDK_INT < 21) {
            int bytesPending = (int)(this.submittedBytes - this.audioTrackUtil.getPlaybackHeadPosition() * (long)this.frameSize);
            int bytesToWrite = this.bufferSize - bytesPending;
            if (bytesToWrite > 0 && (bytesWritten = this.audioTrack.write(this.temporaryBuffer, this.temporaryBufferOffset, bytesToWrite = Math.min(this.temporaryBufferSize, bytesToWrite))) >= 0) {
                this.temporaryBufferOffset += bytesWritten;
            }
        } else {
            bytesWritten = AudioTrack.writeNonBlockingV21(this.audioTrack, buffer, this.temporaryBufferSize);
        }
        if (bytesWritten < 0) {
            throw new WriteException(bytesWritten);
        }
        this.temporaryBufferSize -= bytesWritten;
        this.submittedBytes += (long)bytesWritten;
        if (this.temporaryBufferSize == 0) {
            result |= 2;
        }
        return result;
    }

    @TargetApi(value=21)
    private static int writeNonBlockingV21(android.media.AudioTrack audioTrack, ByteBuffer buffer, int size) {
        return audioTrack.write(buffer, size, 1);
    }

    public boolean hasPendingData() {
        return this.isInitialized() && this.bytesToFrames(this.submittedBytes) > this.audioTrackUtil.getPlaybackHeadPosition();
    }

    public boolean hasEnoughDataToBeginPlayback() {
        return this.submittedBytes >= (long)this.minBufferSize;
    }

    public void setVolume(float volume) {
        this.volume = volume;
        if (this.isInitialized()) {
            if (Util.SDK_INT >= 21) {
                AudioTrack.setVolumeV21(this.audioTrack, volume);
            } else {
                AudioTrack.setVolumeV3(this.audioTrack, volume);
            }
        }
    }

    @TargetApi(value=21)
    private static void setVolumeV21(android.media.AudioTrack audioTrack, float volume) {
        audioTrack.setVolume(volume);
    }

    private static void setVolumeV3(android.media.AudioTrack audioTrack, float volume) {
        audioTrack.setStereoVolume(volume, volume);
    }

    public void pause() {
        if (this.isInitialized()) {
            this.resetSyncParams();
            this.audioTrack.pause();
        }
    }

    public void reset() {
        if (this.isInitialized()) {
            this.submittedBytes = 0L;
            this.temporaryBufferSize = 0;
            this.startMediaTimeUs = 0L;
            this.resetSyncParams();
            int playState = this.audioTrack.getPlayState();
            if (playState == 3) {
                this.audioTrack.pause();
            }
            final android.media.AudioTrack toRelease = this.audioTrack;
            this.audioTrack = null;
            this.audioTrackUtil = null;
            this.releasingConditionVariable.close();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        toRelease.release();
                    }
                    finally {
                        AudioTrack.this.releasingConditionVariable.open();
                    }
                }
            }.start();
        }
    }

    private boolean hasCurrentPositionUs() {
        return this.isInitialized() && this.startMediaTimeUs != 0L;
    }

    private void maybeSampleSyncParams() {
        long playbackPositionUs = this.audioTrackUtil.getPlaybackHeadPositionUs();
        if (playbackPositionUs == 0L) {
            return;
        }
        long systemClockUs = System.nanoTime() / 1000L;
        if (systemClockUs - this.lastPlayheadSampleTimeUs >= 30000L) {
            this.playheadOffsets[this.nextPlayheadOffsetIndex] = playbackPositionUs - systemClockUs;
            this.nextPlayheadOffsetIndex = (this.nextPlayheadOffsetIndex + 1) % 10;
            if (this.playheadOffsetCount < 10) {
                ++this.playheadOffsetCount;
            }
            this.lastPlayheadSampleTimeUs = systemClockUs;
            this.smoothedPlayheadOffsetUs = 0L;
            for (int i = 0; i < this.playheadOffsetCount; ++i) {
                this.smoothedPlayheadOffsetUs += this.playheadOffsets[i] / (long)this.playheadOffsetCount;
            }
        }
        if (systemClockUs - this.lastTimestampSampleTimeUs >= 500000L) {
            this.audioTimestampSet = this.audioTrackUtil.updateTimestamp();
            if (this.audioTimestampSet) {
                long audioTimestampUs = this.audioTrackUtil.getTimestampNanoTime() / 1000L;
                long audioTimestampFramePosition = this.audioTrackUtil.getTimestampFramePosition();
                if (audioTimestampUs < this.resumeSystemTimeUs) {
                    this.audioTimestampSet = false;
                } else if (Math.abs(audioTimestampUs - systemClockUs) > 5000000L) {
                    this.audioTimestampSet = false;
                    Log.w((String)TAG, (String)("Spurious audio timestamp (system clock mismatch): " + audioTimestampFramePosition + ", " + audioTimestampUs + ", " + systemClockUs + ", " + playbackPositionUs));
                } else if (Math.abs(this.framesToDurationUs(audioTimestampFramePosition) - playbackPositionUs) > 5000000L) {
                    this.audioTimestampSet = false;
                    Log.w((String)TAG, (String)("Spurious audio timestamp (frame position mismatch): " + audioTimestampFramePosition + ", " + audioTimestampUs + ", " + systemClockUs + ", " + playbackPositionUs));
                }
            }
            if (this.getLatencyMethod != null) {
                try {
                    this.latencyUs = (long)((Integer)this.getLatencyMethod.invoke((Object)this.audioTrack, (Object[])null)).intValue() * 1000L - this.framesToDurationUs(this.bytesToFrames(this.bufferSize));
                    this.latencyUs = Math.max(this.latencyUs, 0L);
                    if (this.latencyUs > 5000000L) {
                        Log.w((String)TAG, (String)("Ignoring impossibly large audio latency: " + this.latencyUs));
                        this.latencyUs = 0L;
                    }
                }
                catch (Exception e) {
                    this.getLatencyMethod = null;
                }
            }
            this.lastTimestampSampleTimeUs = systemClockUs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAudioTrackInitialized() throws InitializationException {
        int state = this.audioTrack.getState();
        if (state == 1) {
            return;
        }
        try {
            this.audioTrack.release();
        }
        catch (Exception exception) {
        }
        finally {
            this.audioTrack = null;
        }
        throw new InitializationException(state, this.sampleRate, this.channelConfig, this.bufferSize);
    }

    private long bytesToFrames(long byteCount) {
        if (this.isAc3) {
            return this.ac3Bitrate == 0 ? 0L : byteCount * 8L * (long)this.sampleRate / (long)(1000 * this.ac3Bitrate);
        }
        return byteCount / (long)this.frameSize;
    }

    private long framesToDurationUs(long frameCount) {
        return frameCount * 1000000L / (long)this.sampleRate;
    }

    private long durationUsToFrames(long durationUs) {
        return durationUs * (long)this.sampleRate / 1000000L;
    }

    private void resetSyncParams() {
        this.smoothedPlayheadOffsetUs = 0L;
        this.playheadOffsetCount = 0;
        this.nextPlayheadOffsetIndex = 0;
        this.lastPlayheadSampleTimeUs = 0L;
        this.audioTimestampSet = false;
        this.lastTimestampSampleTimeUs = 0L;
    }

    @TargetApi(value=19)
    private static class AudioTrackUtilV19
    extends AudioTrackUtil {
        private final AudioTimestamp audioTimestamp = new AudioTimestamp();
        private long rawTimestampFramePositionWrapCount;
        private long lastRawTimestampFramePosition;
        private long lastTimestampFramePosition;

        public AudioTrackUtilV19(android.media.AudioTrack audioTrack) {
            super(audioTrack);
        }

        @Override
        public boolean updateTimestamp() {
            boolean updated = this.audioTrack.getTimestamp(this.audioTimestamp);
            if (updated) {
                long rawFramePosition = this.audioTimestamp.framePosition;
                if (this.lastRawTimestampFramePosition > rawFramePosition) {
                    ++this.rawTimestampFramePositionWrapCount;
                }
                this.lastRawTimestampFramePosition = rawFramePosition;
                this.lastTimestampFramePosition = rawFramePosition + (this.rawTimestampFramePositionWrapCount << 32);
            }
            return updated;
        }

        @Override
        public long getTimestampNanoTime() {
            return this.audioTimestamp.nanoTime;
        }

        @Override
        public long getTimestampFramePosition() {
            return this.lastTimestampFramePosition;
        }
    }

    private static class AudioTrackUtil {
        protected final android.media.AudioTrack audioTrack;
        private final int sampleRate;
        private long lastRawPlaybackHeadPosition;
        private long rawPlaybackHeadWrapCount;

        public AudioTrackUtil(android.media.AudioTrack audioTrack) {
            this.audioTrack = audioTrack;
            this.sampleRate = audioTrack.getSampleRate();
        }

        public long getPlaybackHeadPosition() {
            long rawPlaybackHeadPosition = 0xFFFFFFFFL & (long)this.audioTrack.getPlaybackHeadPosition();
            if (this.lastRawPlaybackHeadPosition > rawPlaybackHeadPosition) {
                ++this.rawPlaybackHeadWrapCount;
            }
            this.lastRawPlaybackHeadPosition = rawPlaybackHeadPosition;
            return rawPlaybackHeadPosition + (this.rawPlaybackHeadWrapCount << 32);
        }

        public long getPlaybackHeadPositionUs() {
            return this.getPlaybackHeadPosition() * 1000000L / (long)this.sampleRate;
        }

        public boolean updateTimestamp() {
            return false;
        }

        public long getTimestampNanoTime() {
            throw new UnsupportedOperationException();
        }

        public long getTimestampFramePosition() {
            throw new UnsupportedOperationException();
        }
    }

    public static class WriteException
    extends Exception {
        public final int errorCode;

        public WriteException(int errorCode) {
            super("AudioTrack write failed: " + errorCode);
            this.errorCode = errorCode;
        }
    }

    public static class InitializationException
    extends Exception {
        public final int audioTrackState;

        public InitializationException(int audioTrackState, int sampleRate, int channelConfig, int bufferSize) {
            super("AudioTrack init failed: " + audioTrackState + ", Config(" + sampleRate + ", " + channelConfig + ", " + bufferSize + ")");
            this.audioTrackState = audioTrackState;
        }
    }
}

