/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.audio;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;

public final class AudioCapabilitiesReceiver {
    private static final AudioCapabilities DEFAULT_AUDIO_CAPABILITIES = new AudioCapabilities(new int[]{2}, 2);
    private final Context context;
    private final Listener listener;
    private final BroadcastReceiver receiver;

    public AudioCapabilitiesReceiver(Context context, Listener listener) {
        this.context = Assertions.checkNotNull(context);
        this.listener = Assertions.checkNotNull(listener);
        this.receiver = Util.SDK_INT >= 21 ? new HdmiAudioPlugBroadcastReceiver() : null;
    }

    @TargetApi(value=21)
    public void register() {
        if (this.receiver != null) {
            this.context.registerReceiver(this.receiver, new IntentFilter("android.media.action.HDMI_AUDIO_PLUG"));
        }
        this.listener.onAudioCapabilitiesChanged(DEFAULT_AUDIO_CAPABILITIES);
    }

    public void unregister() {
        if (this.receiver != null) {
            this.context.unregisterReceiver(this.receiver);
        }
    }

    @TargetApi(value=21)
    private final class HdmiAudioPlugBroadcastReceiver
    extends BroadcastReceiver {
        private HdmiAudioPlugBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!action.equals("android.media.action.HDMI_AUDIO_PLUG")) {
                return;
            }
            AudioCapabilitiesReceiver.this.listener.onAudioCapabilitiesChanged(new AudioCapabilities(intent.getIntArrayExtra("android.media.extra.ENCODINGS"), intent.getIntExtra("android.media.extra.MAX_CHANNEL_COUNT", 0)));
        }
    }

    public static interface Listener {
        public void onAudioCapabilitiesChanged(AudioCapabilities var1);
    }
}

