/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import com.google.android.exoplayer.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MediaFormat {
    private static final String KEY_PIXEL_WIDTH_HEIGHT_RATIO = "com.google.android.videos.pixelWidthHeightRatio";
    public static final int NO_VALUE = -1;
    public final String mimeType;
    public final int maxInputSize;
    public final int width;
    public final int height;
    public final float pixelWidthHeightRatio;
    public final int channelCount;
    public final int sampleRate;
    public final int bitrate;
    private int maxWidth;
    private int maxHeight;
    public final List<byte[]> initializationData;
    private int hashCode;
    private android.media.MediaFormat frameworkMediaFormat;

    @TargetApi(value=16)
    public static MediaFormat createFromFrameworkMediaFormatV16(android.media.MediaFormat format) {
        return new MediaFormat(format);
    }

    public static MediaFormat createVideoFormat(String mimeType, int maxInputSize, int width, int height, List<byte[]> initializationData) {
        return MediaFormat.createVideoFormat(mimeType, maxInputSize, width, height, 1.0f, initializationData);
    }

    public static MediaFormat createVideoFormat(String mimeType, int maxInputSize, int width, int height, float pixelWidthHeightRatio, List<byte[]> initializationData) {
        return new MediaFormat(mimeType, maxInputSize, width, height, pixelWidthHeightRatio, -1, -1, -1, initializationData);
    }

    public static MediaFormat createAudioFormat(String mimeType, int maxInputSize, int channelCount, int sampleRate, List<byte[]> initializationData) {
        return new MediaFormat(mimeType, maxInputSize, -1, -1, -1.0f, channelCount, sampleRate, -1, initializationData);
    }

    public static MediaFormat createAudioFormat(String mimeType, int maxInputSize, int channelCount, int sampleRate, int bitrate, List<byte[]> initializationData) {
        return new MediaFormat(mimeType, maxInputSize, -1, -1, -1.0f, channelCount, sampleRate, bitrate, initializationData);
    }

    public static MediaFormat createId3Format() {
        return MediaFormat.createFormatForMimeType("application/id3");
    }

    public static MediaFormat createEia608Format() {
        return MediaFormat.createFormatForMimeType("application/eia-608");
    }

    public static MediaFormat createTtmlFormat() {
        return MediaFormat.createFormatForMimeType("application/ttml+xml");
    }

    public static MediaFormat createFormatForMimeType(String mimeType) {
        return new MediaFormat(mimeType, -1, -1, -1, -1.0f, -1, -1, -1, null);
    }

    @TargetApi(value=16)
    private MediaFormat(android.media.MediaFormat format) {
        this.frameworkMediaFormat = format;
        this.mimeType = format.getString("mime");
        this.maxInputSize = MediaFormat.getOptionalIntegerV16(format, "max-input-size");
        this.width = MediaFormat.getOptionalIntegerV16(format, "width");
        this.height = MediaFormat.getOptionalIntegerV16(format, "height");
        this.channelCount = MediaFormat.getOptionalIntegerV16(format, "channel-count");
        this.sampleRate = MediaFormat.getOptionalIntegerV16(format, "sample-rate");
        this.bitrate = MediaFormat.getOptionalIntegerV16(format, "bitrate");
        this.pixelWidthHeightRatio = MediaFormat.getOptionalFloatV16(format, KEY_PIXEL_WIDTH_HEIGHT_RATIO);
        this.initializationData = new ArrayList<byte[]>();
        int i = 0;
        while (format.containsKey("csd-" + i)) {
            ByteBuffer buffer = format.getByteBuffer("csd-" + i);
            byte[] data = new byte[buffer.limit()];
            buffer.get(data);
            this.initializationData.add(data);
            buffer.flip();
            ++i;
        }
        this.maxWidth = -1;
        this.maxHeight = -1;
    }

    private MediaFormat(String mimeType, int maxInputSize, int width, int height, float pixelWidthHeightRatio, int channelCount, int sampleRate, int bitrate, List<byte[]> initializationData) {
        this.mimeType = mimeType;
        this.maxInputSize = maxInputSize;
        this.width = width;
        this.height = height;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
        this.bitrate = bitrate;
        this.initializationData = initializationData == null ? Collections.emptyList() : initializationData;
        this.maxWidth = -1;
        this.maxHeight = -1;
    }

    public void setMaxVideoDimensions(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        if (this.frameworkMediaFormat != null) {
            this.maybeSetMaxDimensionsV16(this.frameworkMediaFormat);
        }
    }

    public int getMaxVideoWidth() {
        return this.maxWidth;
    }

    public int getMaxVideoHeight() {
        return this.maxHeight;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + this.maxInputSize;
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            result = 31 * result + Float.floatToRawIntBits(this.pixelWidthHeightRatio);
            result = 31 * result + this.maxWidth;
            result = 31 * result + this.maxHeight;
            result = 31 * result + this.channelCount;
            result = 31 * result + this.sampleRate;
            result = 31 * result + this.bitrate;
            for (int i = 0; i < this.initializationData.size(); ++i) {
                result = 31 * result + Arrays.hashCode(this.initializationData.get(i));
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsInternal((MediaFormat)obj, false);
    }

    public boolean equals(MediaFormat other, boolean ignoreMaxDimensions) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsInternal(other, ignoreMaxDimensions);
    }

    private boolean equalsInternal(MediaFormat other, boolean ignoreMaxDimensions) {
        if (this.maxInputSize != other.maxInputSize || this.width != other.width || this.height != other.height || this.pixelWidthHeightRatio != other.pixelWidthHeightRatio || !ignoreMaxDimensions && (this.maxWidth != other.maxWidth || this.maxHeight != other.maxHeight) || this.channelCount != other.channelCount || this.sampleRate != other.sampleRate || !Util.areEqual(this.mimeType, other.mimeType) || this.bitrate != other.bitrate || this.initializationData.size() != other.initializationData.size()) {
            return false;
        }
        for (int i = 0; i < this.initializationData.size(); ++i) {
            if (Arrays.equals(this.initializationData.get(i), other.initializationData.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MediaFormat(" + this.mimeType + ", " + this.maxInputSize + ", " + this.width + ", " + this.height + ", " + this.pixelWidthHeightRatio + ", " + this.channelCount + ", " + this.sampleRate + ", " + this.bitrate + ", " + this.maxWidth + ", " + this.maxHeight + ")";
    }

    @TargetApi(value=16)
    public final android.media.MediaFormat getFrameworkMediaFormatV16() {
        if (this.frameworkMediaFormat == null) {
            android.media.MediaFormat format = new android.media.MediaFormat();
            format.setString("mime", this.mimeType);
            MediaFormat.maybeSetIntegerV16(format, "max-input-size", this.maxInputSize);
            MediaFormat.maybeSetIntegerV16(format, "width", this.width);
            MediaFormat.maybeSetIntegerV16(format, "height", this.height);
            MediaFormat.maybeSetIntegerV16(format, "channel-count", this.channelCount);
            MediaFormat.maybeSetIntegerV16(format, "sample-rate", this.sampleRate);
            MediaFormat.maybeSetIntegerV16(format, "bitrate", this.bitrate);
            MediaFormat.maybeSetFloatV16(format, KEY_PIXEL_WIDTH_HEIGHT_RATIO, this.pixelWidthHeightRatio);
            for (int i = 0; i < this.initializationData.size(); ++i) {
                format.setByteBuffer("csd-" + i, ByteBuffer.wrap(this.initializationData.get(i)));
            }
            this.maybeSetMaxDimensionsV16(format);
            this.frameworkMediaFormat = format;
        }
        return this.frameworkMediaFormat;
    }

    @SuppressLint(value={"InlinedApi"})
    @TargetApi(value=16)
    private final void maybeSetMaxDimensionsV16(android.media.MediaFormat format) {
        MediaFormat.maybeSetIntegerV16(format, "max-width", this.maxWidth);
        MediaFormat.maybeSetIntegerV16(format, "max-height", this.maxHeight);
    }

    @TargetApi(value=16)
    private static final void maybeSetIntegerV16(android.media.MediaFormat format, String key, int value) {
        if (value != -1) {
            format.setInteger(key, value);
        }
    }

    @TargetApi(value=16)
    private static final void maybeSetFloatV16(android.media.MediaFormat format, String key, float value) {
        if (value != -1.0f) {
            format.setFloat(key, value);
        }
    }

    @TargetApi(value=16)
    private static final int getOptionalIntegerV16(android.media.MediaFormat format, String key) {
        return format.containsKey(key) ? format.getInteger(key) : -1;
    }

    @TargetApi(value=16)
    private static final float getOptionalFloatV16(android.media.MediaFormat format, String key) {
        return format.containsKey(key) ? format.getFloat(key) : -1.0f;
    }
}

