/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.os.Handler;
import android.os.SystemClock;
import android.view.Surface;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.TraceUtil;
import com.google.android.exoplayer.util.Util;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecVideoTrackRenderer
extends MediaCodecTrackRenderer {
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    public static final int MSG_SET_SURFACE = 1;
    private final FrameReleaseTimeHelper frameReleaseTimeHelper;
    private final EventListener eventListener;
    private final long allowedJoiningTimeUs;
    private final int videoScalingMode;
    private final int maxDroppedFrameCountToNotify;
    private Surface surface;
    private boolean reportedDrawnToSurface;
    private boolean renderedFirstFrame;
    private long joiningDeadlineUs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrameCount;
    private int currentWidth;
    private int currentHeight;
    private float currentPixelWidthHeightRatio;
    private int lastReportedWidth;
    private int lastReportedHeight;
    private float lastReportedPixelWidthHeightRatio;

    public MediaCodecVideoTrackRenderer(SampleSource source, int videoScalingMode) {
        this(source, null, true, videoScalingMode);
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, int videoScalingMode) {
        this(source, drmSessionManager, playClearSamplesWithoutKeys, videoScalingMode, 0L);
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, int videoScalingMode, long allowedJoiningTimeMs) {
        this(source, null, true, videoScalingMode, allowedJoiningTimeMs);
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, int videoScalingMode, long allowedJoiningTimeMs) {
        this(source, drmSessionManager, playClearSamplesWithoutKeys, videoScalingMode, allowedJoiningTimeMs, null, null, null, -1);
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, int videoScalingMode, long allowedJoiningTimeMs, Handler eventHandler, EventListener eventListener, int maxDroppedFrameCountToNotify) {
        this(source, null, true, videoScalingMode, allowedJoiningTimeMs, null, eventHandler, eventListener, maxDroppedFrameCountToNotify);
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, int videoScalingMode, long allowedJoiningTimeMs, FrameReleaseTimeHelper frameReleaseTimeHelper, Handler eventHandler, EventListener eventListener, int maxDroppedFrameCountToNotify) {
        super(source, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, eventListener);
        this.videoScalingMode = videoScalingMode;
        this.allowedJoiningTimeUs = allowedJoiningTimeMs * 1000L;
        this.frameReleaseTimeHelper = frameReleaseTimeHelper;
        this.eventListener = eventListener;
        this.maxDroppedFrameCountToNotify = maxDroppedFrameCountToNotify;
        this.joiningDeadlineUs = -1L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
    }

    @Override
    protected boolean handlesMimeType(String mimeType) {
        return MimeTypes.isVideo(mimeType) && super.handlesMimeType(mimeType);
    }

    @Override
    protected void onEnabled(long positionUs, boolean joining) {
        super.onEnabled(positionUs, joining);
        this.renderedFirstFrame = false;
        if (joining && this.allowedJoiningTimeUs > 0L) {
            this.joiningDeadlineUs = SystemClock.elapsedRealtime() * 1000L + this.allowedJoiningTimeUs;
        }
        if (this.frameReleaseTimeHelper != null) {
            this.frameReleaseTimeHelper.enable();
        }
    }

    @Override
    protected void seekTo(long positionUs) throws ExoPlaybackException {
        super.seekTo(positionUs);
        this.renderedFirstFrame = false;
        this.joiningDeadlineUs = -1L;
    }

    @Override
    protected boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || !this.codecInitialized() || this.getSourceState() == 2)) {
            this.joiningDeadlineUs = -1L;
            return true;
        }
        if (this.joiningDeadlineUs == -1L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() * 1000L < this.joiningDeadlineUs) {
            return true;
        }
        this.joiningDeadlineUs = -1L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrameCount = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineUs = -1L;
        this.maybeNotifyDroppedFrameCount();
        super.onStopped();
    }

    @Override
    public void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
        if (this.frameReleaseTimeHelper != null) {
            this.frameReleaseTimeHelper.disable();
        }
        super.onDisabled();
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        if (messageType == 1) {
            this.setSurface((Surface)message);
        } else {
            super.handleMessage(messageType, message);
        }
    }

    private void setSurface(Surface surface) throws ExoPlaybackException {
        if (this.surface == surface) {
            return;
        }
        this.surface = surface;
        this.reportedDrawnToSurface = false;
        int state = this.getState();
        if (state == 2 || state == 3) {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    @Override
    protected boolean shouldInitCodec() {
        return super.shouldInitCodec() && this.surface != null;
    }

    @Override
    protected void configureCodec(MediaCodec codec, android.media.MediaFormat format, MediaCrypto crypto) {
        codec.configure(format, this.surface, crypto, 0);
        codec.setVideoScalingMode(this.videoScalingMode);
    }

    @Override
    protected void onInputFormatChanged(MediaFormatHolder holder) throws ExoPlaybackException {
        super.onInputFormatChanged(holder);
        this.currentPixelWidthHeightRatio = holder.format.pixelWidthHeightRatio == -1.0f ? 1.0f : holder.format.pixelWidthHeightRatio;
    }

    @Override
    protected void onOutputFormatChanged(android.media.MediaFormat format) {
        boolean hasCrop = format.containsKey(KEY_CROP_RIGHT) && format.containsKey(KEY_CROP_LEFT) && format.containsKey(KEY_CROP_BOTTOM) && format.containsKey(KEY_CROP_TOP);
        this.currentWidth = hasCrop ? format.getInteger(KEY_CROP_RIGHT) - format.getInteger(KEY_CROP_LEFT) + 1 : format.getInteger("width");
        this.currentHeight = hasCrop ? format.getInteger(KEY_CROP_BOTTOM) - format.getInteger(KEY_CROP_TOP) + 1 : format.getInteger("height");
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec codec, boolean codecIsAdaptive, MediaFormat oldFormat, MediaFormat newFormat) {
        return newFormat.mimeType.equals(oldFormat.mimeType) && (codecIsAdaptive || oldFormat.width == newFormat.width && oldFormat.height == newFormat.height);
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, MediaCodec codec, ByteBuffer buffer, MediaCodec.BufferInfo bufferInfo, int bufferIndex, boolean shouldSkip) {
        long adjustedReleaseTimeNs;
        if (shouldSkip) {
            this.skipOutputBuffer(codec, bufferIndex);
            return true;
        }
        long elapsedSinceStartOfLoopUs = SystemClock.elapsedRealtime() * 1000L - elapsedRealtimeUs;
        long earlyUs = bufferInfo.presentationTimeUs - positionUs - elapsedSinceStartOfLoopUs;
        long systemTimeNs = System.nanoTime();
        long unadjustedFrameReleaseTimeNs = systemTimeNs + earlyUs * 1000L;
        if (this.frameReleaseTimeHelper != null) {
            adjustedReleaseTimeNs = this.frameReleaseTimeHelper.adjustReleaseTime(bufferInfo.presentationTimeUs, unadjustedFrameReleaseTimeNs);
            earlyUs = (adjustedReleaseTimeNs - systemTimeNs) / 1000L;
        } else {
            adjustedReleaseTimeNs = unadjustedFrameReleaseTimeNs;
        }
        if (earlyUs < -30000L) {
            this.dropOutputBuffer(codec, bufferIndex);
            return true;
        }
        if (!this.renderedFirstFrame) {
            this.renderOutputBufferImmediate(codec, bufferIndex);
            this.renderedFirstFrame = true;
            return true;
        }
        if (this.getState() != 3) {
            return false;
        }
        if (Util.SDK_INT >= 21) {
            if (earlyUs < 50000L) {
                this.renderOutputBufferTimedV21(codec, bufferIndex, adjustedReleaseTimeNs);
                return true;
            }
        } else if (earlyUs < 30000L) {
            if (earlyUs > 11000L) {
                try {
                    Thread.sleep((earlyUs - 10000L) / 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBufferImmediate(codec, bufferIndex);
            return true;
        }
        return false;
    }

    private void skipOutputBuffer(MediaCodec codec, int bufferIndex) {
        TraceUtil.beginSection("skipVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, false);
        TraceUtil.endSection();
        ++this.codecCounters.skippedOutputBufferCount;
    }

    private void dropOutputBuffer(MediaCodec codec, int bufferIndex) {
        TraceUtil.beginSection("dropVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, false);
        TraceUtil.endSection();
        ++this.codecCounters.droppedOutputBufferCount;
        ++this.droppedFrameCount;
        if (this.droppedFrameCount == this.maxDroppedFrameCountToNotify) {
            this.maybeNotifyDroppedFrameCount();
        }
    }

    private void renderOutputBufferImmediate(MediaCodec codec, int bufferIndex) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("renderVideoBufferImmediate");
        codec.releaseOutputBuffer(bufferIndex, true);
        TraceUtil.endSection();
        ++this.codecCounters.renderedOutputBufferCount;
        this.maybeNotifyDrawnToSurface();
    }

    @TargetApi(value=21)
    private void renderOutputBufferTimedV21(MediaCodec codec, int bufferIndex, long releaseTimeNs) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBufferTimed");
        codec.releaseOutputBuffer(bufferIndex, releaseTimeNs);
        TraceUtil.endSection();
        ++this.codecCounters.renderedOutputBufferCount;
        this.maybeNotifyDrawnToSurface();
    }

    private void maybeNotifyVideoSizeChanged() {
        if (this.eventHandler == null || this.eventListener == null || this.lastReportedWidth == this.currentWidth && this.lastReportedHeight == this.currentHeight && this.lastReportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio) {
            return;
        }
        final int currentWidth = this.currentWidth;
        final int currentHeight = this.currentHeight;
        final float currentPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onVideoSizeChanged(currentWidth, currentHeight, currentPixelWidthHeightRatio);
            }
        });
        this.lastReportedWidth = currentWidth;
        this.lastReportedHeight = currentHeight;
        this.lastReportedPixelWidthHeightRatio = currentPixelWidthHeightRatio;
    }

    private void maybeNotifyDrawnToSurface() {
        if (this.eventHandler == null || this.eventListener == null || this.reportedDrawnToSurface) {
            return;
        }
        final Surface surface = this.surface;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onDrawnToSurface(surface);
            }
        });
        this.reportedDrawnToSurface = true;
    }

    private void maybeNotifyDroppedFrameCount() {
        if (this.eventHandler == null || this.eventListener == null || this.droppedFrameCount == 0) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        final int countToNotify = this.droppedFrameCount;
        final long elapsedToNotify = now - this.droppedFrameAccumulationStartTimeMs;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onDroppedFrames(countToNotify, elapsedToNotify);
            }
        });
        this.droppedFrameCount = 0;
        this.droppedFrameAccumulationStartTimeMs = now;
    }

    public static interface FrameReleaseTimeHelper {
        public void enable();

        public void disable();

        public long adjustReleaseTime(long var1, long var3);
    }

    public static interface EventListener
    extends MediaCodecTrackRenderer.EventListener {
        public void onDroppedFrames(int var1, long var2);

        public void onVideoSizeChanged(int var1, int var2, float var3);

        public void onDrawnToSurface(Surface var1);
    }
}

