/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer.DecoderInfo;
import com.google.android.exoplayer.util.Util;
import java.util.HashMap;

@TargetApi(value=16)
public class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    private static final HashMap<CodecKey, Pair<String, MediaCodecInfo.CodecCapabilities>> codecs = new HashMap();

    public static DecoderInfo getDecoderInfo(String mimeType, boolean secure) throws DecoderQueryException {
        Pair<String, MediaCodecInfo.CodecCapabilities> info = MediaCodecUtil.getMediaCodecInfo(mimeType, secure);
        if (info == null) {
            return null;
        }
        return new DecoderInfo((String)info.first, MediaCodecUtil.isAdaptive((MediaCodecInfo.CodecCapabilities)info.second));
    }

    public static synchronized void warmCodec(String mimeType, boolean secure) {
        try {
            MediaCodecUtil.getMediaCodecInfo(mimeType, secure);
        }
        catch (DecoderQueryException e) {
            Log.e((String)TAG, (String)"Codec warming failed", (Throwable)e);
        }
    }

    private static synchronized Pair<String, MediaCodecInfo.CodecCapabilities> getMediaCodecInfo(String mimeType, boolean secure) throws DecoderQueryException {
        CodecKey key = new CodecKey(mimeType, secure);
        if (codecs.containsKey(key)) {
            return codecs.get(key);
        }
        MediaCodecListCompat mediaCodecList = Util.SDK_INT >= 21 ? new MediaCodecListCompatV21(secure) : new MediaCodecListCompatV16();
        Pair<String, MediaCodecInfo.CodecCapabilities> codecInfo = MediaCodecUtil.getMediaCodecInfo(key, mediaCodecList);
        if (secure && codecInfo == null && Util.SDK_INT >= 21 && (codecInfo = MediaCodecUtil.getMediaCodecInfo(key, mediaCodecList = new MediaCodecListCompatV16())) != null) {
            Log.w((String)TAG, (String)("MediaCodecList API didn't list secure decoder for: " + mimeType + ". Assuming: " + (String)codecInfo.first));
        }
        return codecInfo;
    }

    private static Pair<String, MediaCodecInfo.CodecCapabilities> getMediaCodecInfo(CodecKey key, MediaCodecListCompat mediaCodecList) throws DecoderQueryException {
        try {
            return MediaCodecUtil.getMediaCodecInfoInternal(key, mediaCodecList);
        }
        catch (Exception e) {
            throw new DecoderQueryException(e);
        }
    }

    private static Pair<String, MediaCodecInfo.CodecCapabilities> getMediaCodecInfoInternal(CodecKey key, MediaCodecListCompat mediaCodecList) {
        String mimeType = key.mimeType;
        int numberOfCodecs = mediaCodecList.getCodecCount();
        boolean secureDecodersExplicit = mediaCodecList.secureDecodersExplicit();
        for (int i = 0; i < numberOfCodecs; ++i) {
            MediaCodecInfo info = mediaCodecList.getCodecInfoAt(i);
            String codecName = info.getName();
            if (info.isEncoder() || !codecName.startsWith("OMX.") || !secureDecodersExplicit && codecName.endsWith(".secure")) continue;
            String[] supportedTypes = info.getSupportedTypes();
            for (int j = 0; j < supportedTypes.length; ++j) {
                String supportedType = supportedTypes[j];
                if (!supportedType.equalsIgnoreCase(mimeType)) continue;
                MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(supportedType);
                boolean secure = mediaCodecList.isSecurePlaybackSupported(key.mimeType, capabilities);
                if (!secureDecodersExplicit) {
                    codecs.put(key.secure ? new CodecKey(mimeType, false) : key, (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)codecName, (Object)capabilities));
                    if (secure) {
                        codecs.put(key.secure ? key : new CodecKey(mimeType, true), (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)(codecName + ".secure"), (Object)capabilities));
                    }
                } else {
                    codecs.put(key.secure == secure ? key : new CodecKey(mimeType, secure), (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)codecName, (Object)capabilities));
                }
                if (!codecs.containsKey(key)) continue;
                return codecs.get(key);
            }
        }
        return null;
    }

    private static boolean isAdaptive(MediaCodecInfo.CodecCapabilities capabilities) {
        if (Util.SDK_INT >= 19) {
            return MediaCodecUtil.isAdaptiveV19(capabilities);
        }
        return false;
    }

    @TargetApi(value=19)
    private static boolean isAdaptiveV19(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("adaptive-playback");
    }

    public static boolean isH264ProfileSupported(int profile, int level) throws DecoderQueryException {
        Pair<String, MediaCodecInfo.CodecCapabilities> info = MediaCodecUtil.getMediaCodecInfo("video/avc", false);
        if (info == null) {
            return false;
        }
        MediaCodecInfo.CodecCapabilities capabilities = (MediaCodecInfo.CodecCapabilities)info.second;
        for (int i = 0; i < capabilities.profileLevels.length; ++i) {
            MediaCodecInfo.CodecProfileLevel profileLevel = capabilities.profileLevels[i];
            if (profileLevel.profile != profile || profileLevel.level < level) continue;
            return true;
        }
        return false;
    }

    public static int maxH264DecodableFrameSize() throws DecoderQueryException {
        Pair<String, MediaCodecInfo.CodecCapabilities> info = MediaCodecUtil.getMediaCodecInfo("video/avc", false);
        if (info == null) {
            return 0;
        }
        int maxH264DecodableFrameSize = 0;
        MediaCodecInfo.CodecCapabilities capabilities = (MediaCodecInfo.CodecCapabilities)info.second;
        for (int i = 0; i < capabilities.profileLevels.length; ++i) {
            MediaCodecInfo.CodecProfileLevel profileLevel = capabilities.profileLevels[i];
            maxH264DecodableFrameSize = Math.max(MediaCodecUtil.avcLevelToMaxFrameSize(profileLevel.level), maxH264DecodableFrameSize);
        }
        return maxH264DecodableFrameSize;
    }

    private static int avcLevelToMaxFrameSize(int avcLevel) {
        switch (avcLevel) {
            case 1: {
                return 25344;
            }
            case 2: {
                return 25344;
            }
            case 8: {
                return 101376;
            }
            case 16: {
                return 101376;
            }
            case 32: {
                return 101376;
            }
            case 64: {
                return 202752;
            }
            case 128: {
                return 414720;
            }
            case 256: {
                return 414720;
            }
            case 512: {
                return 921600;
            }
            case 1024: {
                return 0x140000;
            }
            case 2048: {
                return 0x200000;
            }
            case 4096: {
                return 0x200000;
            }
            case 8192: {
                return 0x220000;
            }
            case 16384: {
                return 5652480;
            }
            case 32768: {
                return 0x900000;
            }
        }
        return -1;
    }

    private static final class CodecKey {
        public final String mimeType;
        public final boolean secure;

        public CodecKey(String mimeType, boolean secure) {
            this.mimeType = mimeType;
            this.secure = secure;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.secure ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != CodecKey.class) {
                return false;
            }
            CodecKey other = (CodecKey)obj;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)other.mimeType) && this.secure == other.secure;
        }
    }

    private static final class MediaCodecListCompatV16
    implements MediaCodecListCompat {
        private MediaCodecListCompatV16() {
        }

        @Override
        public int getCodecCount() {
            return MediaCodecList.getCodecCount();
        }

        @Override
        public MediaCodecInfo getCodecInfoAt(int index) {
            return MediaCodecList.getCodecInfoAt((int)index);
        }

        @Override
        public boolean secureDecodersExplicit() {
            return false;
        }

        @Override
        public boolean isSecurePlaybackSupported(String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return "video/avc".equals(mimeType);
        }
    }

    @TargetApi(value=21)
    private static final class MediaCodecListCompatV21
    implements MediaCodecListCompat {
        private final int codecKind;
        private MediaCodecInfo[] mediaCodecInfos;

        public MediaCodecListCompatV21(boolean includeSecure) {
            this.codecKind = includeSecure ? 1 : 0;
        }

        @Override
        public int getCodecCount() {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos.length;
        }

        @Override
        public MediaCodecInfo getCodecInfoAt(int index) {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos[index];
        }

        @Override
        public boolean secureDecodersExplicit() {
            return true;
        }

        @Override
        public boolean isSecurePlaybackSupported(String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return capabilities.isFeatureSupported("secure-playback");
        }

        private void ensureMediaCodecInfosInitialized() {
            if (this.mediaCodecInfos == null) {
                this.mediaCodecInfos = new MediaCodecList(this.codecKind).getCodecInfos();
            }
        }
    }

    private static interface MediaCodecListCompat {
        public int getCodecCount();

        public MediaCodecInfo getCodecInfoAt(int var1);

        public boolean secureDecodersExplicit();

        public boolean isSecurePlaybackSupported(String var1, MediaCodecInfo.CodecCapabilities var2);
    }

    public static class DecoderQueryException
    extends Exception {
        private DecoderQueryException(Throwable cause) {
            super("Failed to query underlying media codecs", cause);
        }
    }
}

