/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.audio.AudioTrack;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.util.MimeTypes;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecAudioTrackRenderer
extends MediaCodecTrackRenderer {
    public static final int MSG_SET_VOLUME = 1;
    private final EventListener eventListener;
    private final AudioTrack audioTrack;
    private int audioSessionId;
    private long currentPositionUs;

    public MediaCodecAudioTrackRenderer(SampleSource source) {
        this(source, null, true);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys) {
        this(source, drmSessionManager, playClearSamplesWithoutKeys, null, null);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, Handler eventHandler, EventListener eventListener) {
        this(source, null, true, eventHandler, eventListener);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, EventListener eventListener) {
        super(source, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, eventListener);
        this.eventListener = eventListener;
        this.audioSessionId = 0;
        this.audioTrack = new AudioTrack();
    }

    @Override
    protected boolean isTimeSource() {
        return true;
    }

    @Override
    protected boolean handlesMimeType(String mimeType) {
        return MimeTypes.isAudio(mimeType) && super.handlesMimeType(mimeType);
    }

    @Override
    protected void onEnabled(long positionUs, boolean joining) {
        super.onEnabled(positionUs, joining);
        this.currentPositionUs = Long.MIN_VALUE;
    }

    @Override
    protected void onOutputFormatChanged(MediaFormat format) {
        this.audioTrack.reconfigure(format);
    }

    protected void onAudioSessionId(int audioSessionId) {
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.audioTrack.play();
    }

    @Override
    protected void onStopped() {
        this.audioTrack.pause();
        super.onStopped();
    }

    @Override
    protected boolean isEnded() {
        return super.isEnded() && (!this.audioTrack.hasPendingData() || !this.audioTrack.hasEnoughDataToBeginPlayback());
    }

    @Override
    protected boolean isReady() {
        return this.audioTrack.hasPendingData() || super.isReady() && this.getSourceState() == 2;
    }

    @Override
    protected long getCurrentPositionUs() {
        long audioTrackCurrentPositionUs = this.audioTrack.getCurrentPositionUs(this.isEnded());
        this.currentPositionUs = audioTrackCurrentPositionUs == Long.MIN_VALUE ? Math.max(this.currentPositionUs, super.getCurrentPositionUs()) : Math.max(this.currentPositionUs, audioTrackCurrentPositionUs);
        return this.currentPositionUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDisabled() {
        this.audioSessionId = 0;
        try {
            this.audioTrack.reset();
        }
        finally {
            super.onDisabled();
        }
    }

    @Override
    protected void seekTo(long positionUs) throws ExoPlaybackException {
        super.seekTo(positionUs);
        this.audioTrack.reset();
        this.currentPositionUs = Long.MIN_VALUE;
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, MediaCodec codec, ByteBuffer buffer, MediaCodec.BufferInfo bufferInfo, int bufferIndex, boolean shouldSkip) throws ExoPlaybackException {
        int handleBufferResult;
        if (shouldSkip) {
            codec.releaseOutputBuffer(bufferIndex, false);
            ++this.codecCounters.skippedOutputBufferCount;
            this.audioTrack.handleDiscontinuity();
            return true;
        }
        if (!this.audioTrack.isInitialized()) {
            try {
                if (this.audioSessionId != 0) {
                    this.audioTrack.initialize(this.audioSessionId);
                } else {
                    this.audioSessionId = this.audioTrack.initialize();
                    this.onAudioSessionId(this.audioSessionId);
                }
            }
            catch (AudioTrack.InitializationException e) {
                this.notifyAudioTrackInitializationError(e);
                throw new ExoPlaybackException(e);
            }
            if (this.getState() == 3) {
                this.audioTrack.play();
            }
        }
        try {
            handleBufferResult = this.audioTrack.handleBuffer(buffer, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs);
        }
        catch (AudioTrack.WriteException e) {
            this.notifyAudioTrackWriteError(e);
            throw new ExoPlaybackException(e);
        }
        if ((handleBufferResult & 1) != 0) {
            this.currentPositionUs = Long.MIN_VALUE;
        }
        if ((handleBufferResult & 2) != 0) {
            codec.releaseOutputBuffer(bufferIndex, false);
            ++this.codecCounters.renderedOutputBufferCount;
            return true;
        }
        return false;
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        if (messageType == 1) {
            this.audioTrack.setVolume(((Float)message).floatValue());
        } else {
            super.handleMessage(messageType, message);
        }
    }

    private void notifyAudioTrackInitializationError(final AudioTrack.InitializationException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackInitializationError(e);
                }
            });
        }
    }

    private void notifyAudioTrackWriteError(final AudioTrack.WriteException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackWriteError(e);
                }
            });
        }
    }

    public static interface EventListener
    extends MediaCodecTrackRenderer.EventListener {
        public void onAudioTrackInitializationError(AudioTrack.InitializationException var1);

        public void onAudioTrackWriteError(AudioTrack.WriteException var1);
    }
}

