/*
 * Copyright (c) 2007, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.security.cert;


/**
 * The CRLReason enumeration specifies the reason that a certificate
 * is revoked, as defined in <a href="http://www.ietf.org/rfc/rfc3280.txt">
 * RFC 3280: Internet X.509 Public Key Infrastructure Certificate and CRL
 * Profile</a>.
 *
 * @author Sean Mullan
 * @since 1.7
 * @see java.security.cert.X509CRLEntry#getRevocationReason
 * @see java.security.cert.CertificateRevokedException#getRevocationReason
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum CRLReason {
/**
 * This reason indicates that it is unspecified as to why the
 * certificate has been revoked.
 */

UNSPECIFIED,
/**
 * This reason indicates that it is known or suspected that the
 * certificate subject's private key has been compromised. It applies
 * to end-entity certificates only.
 */

KEY_COMPROMISE,
/**
 * This reason indicates that it is known or suspected that the
 * certificate subject's private key has been compromised. It applies
 * to certificate authority (CA) certificates only.
 */

CA_COMPROMISE,
/**
 * This reason indicates that the subject's name or other information
 * has changed.
 */

AFFILIATION_CHANGED,
/**
 * This reason indicates that the certificate has been superseded.
 */

SUPERSEDED,
/**
 * This reason indicates that the certificate is no longer needed.
 */

CESSATION_OF_OPERATION,
/**
 * This reason indicates that the certificate has been put on hold.
 */

CERTIFICATE_HOLD,
/**
 * Unused reason.
 */

UNUSED,
/**
 * This reason indicates that the certificate was previously on hold
 * and should be removed from the CRL. It is for use with delta CRLs.
 */

REMOVE_FROM_CRL,
/**
 * This reason indicates that the privileges granted to the subject of
 * the certificate have been withdrawn.
 */

PRIVILEGE_WITHDRAWN,
/**
 * This reason indicates that it is known or suspected that the
 * certificate subject's private key has been compromised. It applies
 * to authority attribute (AA) certificates only.
 */

AA_COMPROMISE;
}

