/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.rtt;

import android.net.wifi.ScanResult;
import java.util.List;
import android.net.wifi.aware.IdentityChangedListener;
import android.net.wifi.aware.WifiAwareManager;
import android.os.Handler;
import android.net.wifi.aware.AttachCallback;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.PeerHandle;

/**
 * Defines the ranging request to other devices. The ranging request is built using
 * {@link android.net.wifi.rtt.RangingRequest.Builder RangingRequest.Builder}.
 * A ranging request is executed using
 * {@link android.net.wifi.rtt.WifiRttManager#startRanging(android.net.wifi.rtt.RangingRequest,java.util.concurrent.Executor,android.net.wifi.rtt.RangingResultCallback) WifiRttManager#startRanging(RangingRequest, java.util.concurrent.Executor, RangingResultCallback)}.
 * <p>
 * The ranging request is a batch request - specifying a set of devices (specified using
 * {@link android.net.wifi.rtt.RangingRequest.Builder#addAccessPoint(android.net.wifi.ScanResult) RangingRequest.Builder#addAccessPoint(ScanResult)} and
 * {@link android.net.wifi.rtt.RangingRequest.Builder#addAccessPoints(java.util.List) RangingRequest.Builder#addAccessPoints(List)}).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingRequest implements android.os.Parcelable {

private RangingRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of peers to range which can be specified in a single {@code
 * RangingRequest}. The limit applies no matter how the peers are added to the request, e.g.
 * through {@link android.net.wifi.rtt.RangingRequest.Builder#addAccessPoint(android.net.wifi.ScanResult) RangingRequest.Builder#addAccessPoint(ScanResult)} or
 * {@link android.net.wifi.rtt.RangingRequest.Builder#addAccessPoints(java.util.List) RangingRequest.Builder#addAccessPoints(List)}.
 *
 * @return Maximum number of peers.
 */

public static int getMaxPeers() { throw new RuntimeException("Stub!"); }

/**
 * Returns the default RTT burst size used to determine the average range.
 *
 * @return the RTT burst size used by default
 */

public static int getDefaultRttBurstSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum RTT burst size that can be used to determine a average range.
 *
 * @return the minimum RTT burst size that can be used
 */

public static int getMinRttBurstSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum RTT burst size that can be used to determine a average range.
 *
 * @return the maximum RTT burst size that can be used
 */

public static int getMaxRttBurstSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns the RTT burst size used to determine the average range.
 *
 * @return the RTT burst size used
 */

public int getRttBurstSize() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.rtt.RangingRequest> CREATOR;
static { CREATOR = null; }
/**
 * Builder class used to construct {@link android.net.wifi.rtt.RangingRequest RangingRequest} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set the RTT Burst size for the ranging request.
 * <p>
 * If not set, the default RTT burst size given by
 * {@link #getDefaultRttBurstSize()} is used to determine the default value.
 * If set, the value must be in the range {@link #getMinRttBurstSize()} and
 * {@link #getMaxRttBurstSize()} inclusively, or a
 * {@link java.lang.IllegalArgumentException} will be thrown.
 *
 * @param rttBurstSize The number of FTM packets used to estimate a range.
 * @return The builder to facilitate chaining
 * {@code builder.setXXX(..).setXXX(..)}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder setRttBurstSize(int rttBurstSize) { throw new RuntimeException("Stub!"); }

/**
 * Add the device specified by the {@link android.net.wifi.ScanResult ScanResult} to the list of devices with
 * which to measure range. The total number of peers added to a request cannot exceed the
 * limit specified by {@link #getMaxPeers()}.
 * <p>
 * Ranging will only be supported if the Access Point supports IEEE 802.11mc, also known as
 * two-sided RTT. Use {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()} to verify the Access Point's
 * capabilities. If not supported the result status will be
 * {@link android.net.wifi.rtt.RangingResult#STATUS_RESPONDER_DOES_NOT_SUPPORT_IEEE80211MC RangingResult#STATUS_RESPONDER_DOES_NOT_SUPPORT_IEEE80211MC}.
 *
 * @param apInfo Information of an Access Point (AP) obtained in a Scan Result.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 */

public android.net.wifi.rtt.RangingRequest.Builder addAccessPoint(@android.annotation.NonNull android.net.wifi.ScanResult apInfo) { throw new RuntimeException("Stub!"); }

/**
 * Add the devices specified by the {@link android.net.wifi.ScanResult ScanResult}s to the list of devices with
 * which to measure range. The total number of peers added to a request cannot exceed the
 * limit specified by {@link #getMaxPeers()}.
 * <p>
 * Ranging will only be supported if the Access Point supports IEEE 802.11mc, also known as
 * two-sided RTT. Use {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()} to verify the Access Point's
 * capabilities. If not supported, the result status will be
 * {@link android.net.wifi.rtt.RangingResult#STATUS_RESPONDER_DOES_NOT_SUPPORT_IEEE80211MC RangingResult#STATUS_RESPONDER_DOES_NOT_SUPPORT_IEEE80211MC}.
 *
 * @param apInfos Information of an Access Points (APs) obtained in a Scan Result.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 */

public android.net.wifi.rtt.RangingRequest.Builder addAccessPoints(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult> apInfos) { throw new RuntimeException("Stub!"); }

/**
 * Add the non-802.11mc capable device specified by the {@link android.net.wifi.ScanResult ScanResult} to the list of
 * devices with which to measure range. The total number of peers added to a request cannot
 * exceed the limit specified by {@link #getMaxPeers()}.
 * <p>
 * Accurate ranging cannot be supported if the Access Point does not support IEEE 802.11mc,
 * and instead an alternate protocol called one-sided RTT will be used with lower
 * accuracy. Use {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()} to verify the Access Point)s) are
 * not 802.11mc capable.
 * <p>
 * One-sided RTT does not subtract the RTT turnaround time at the Access Point, which can
 * add hundreds of meters to the estimate. With experimentation it is possible to use this
 * information to make a statistical estimate of the range by taking multiple measurements
 * to several Access Points and normalizing the result. For some applications this can be
 * used to improve range estimates based on Receive Signal Strength Indication (RSSI), but
 * will not be as accurate as IEEE 802.11mc (two-sided RTT).
 * <p>
 * Note: one-sided RTT should only be used if you are very familiar with statistical
 * estimation techniques.
 *
 * @param apInfo Information of an Access Point (AP) obtained in a Scan Result.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder addNon80211mcCapableAccessPoint(@android.annotation.NonNull android.net.wifi.ScanResult apInfo) { throw new RuntimeException("Stub!"); }

/**
 * Add the non-802.11mc capable devices specified by the {@link android.net.wifi.ScanResult ScanResult} to the list of
 * devices with which to measure range. The total number of peers added to a request cannot
 * exceed the limit specified by {@link #getMaxPeers()}.
 * <p>
 * Accurate ranging cannot be supported if the Access Point does not support IEEE 802.11mc,
 * and instead an alternate protocol called one-sided RTT will be used with lower
 * accuracy. Use {@link android.net.wifi.ScanResult#is80211mcResponder() ScanResult#is80211mcResponder()} to verify the Access Point)s) are
 * not 802.11mc capable.
 * <p>
 * One-sided RTT does not subtract the RTT turnaround time at the Access Point, which can
 * add hundreds of meters to the estimate. With experimentation it is possible to use this
 * information to make a statistical estimate of the range by taking multiple measurements
 * to several Access Points and normalizing the result. For some applications this can be
 * used to improve range estimates based on Receive Signal Strength Indication (RSSI), but
 * will not be as accurate as IEEE 802.11mc (two-sided RTT).
 * <p>
 * Note: one-sided RTT should only be used if you are very familiar with statistical
 * estimation techniques.
 *
 * @param apInfos Information of an Access Points (APs) obtained in a Scan Result.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.RangingRequest.Builder addNon80211mcCapableAccessPoints(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult> apInfos) { throw new RuntimeException("Stub!"); }

/**
 * Add the device specified by the {@code peerMacAddress} to the list of devices with
 * which to measure range.
 * <p>
 * The MAC address may be obtained out-of-band from a peer Wi-Fi Aware device. A Wi-Fi
 * Aware device may obtain its MAC address using the {@link android.net.wifi.aware.IdentityChangedListener IdentityChangedListener}
 * provided to
 * {@link android.net.wifi.aware.WifiAwareManager#attach(android.net.wifi.aware.AttachCallback,android.net.wifi.aware.IdentityChangedListener,android.os.Handler) WifiAwareManager#attach(AttachCallback, IdentityChangedListener, Handler)}.
 * <p>
 * Note: in order to use this API the device must support Wi-Fi Aware
 * {@link android.net.wifi.aware}. The peer device which is being ranged to must be
 * configured to publish a service (with any name) with:
 * <li>Type {@link android.net.wifi.aware.PublishConfig#PUBLISH_TYPE_UNSOLICITED}.
 * <li>Ranging enabled
 * {@link android.net.wifi.aware.PublishConfig.Builder#setRangingEnabled(boolean)}.
 *
 * @param peerMacAddress The MAC address of the Wi-Fi Aware peer.
 * @return The builder, to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 */

public android.net.wifi.rtt.RangingRequest.Builder addWifiAwarePeer(@android.annotation.NonNull android.net.MacAddress peerMacAddress) { throw new RuntimeException("Stub!"); }

/**
 * Add a device specified by a {@link android.net.wifi.aware.PeerHandle PeerHandle} to the list of devices with which to
 * measure range.
 * <p>
 * The {@link android.net.wifi.aware.PeerHandle PeerHandle} may be obtained as part of the Wi-Fi Aware discovery process. E.g.
 * using {@link android.net.wifi.aware.DiscoverySessionCallback#onServiceDiscovered(android.net.wifi.aware.PeerHandle,byte[],java.util.List) DiscoverySessionCallback#onServiceDiscovered(PeerHandle, byte[], List)}.
 * <p>
 * Note: in order to use this API the device must support Wi-Fi Aware
 * {@link android.net.wifi.aware}. The requesting device can be either publisher or
 * subscriber in a discovery session. For both requesting device and peer device ranging
 * must be enabled on the discovery session:
 * <li>{@link android.net.wifi.aware.PublishConfig.Builder#setRangingEnabled(boolean)} for
 * publisher.</li>
 * <li>Either {@link android.net.wifi.aware.SubscribeConfig.Builder#setMinDistanceMm(int)}
 * or {@link android.net.wifi.aware.SubscribeConfig.Builder#setMaxDistanceMm(int)} must be
 * set to enable ranging on subscriber </li>
 *
 * @param peerHandle The peer handler of the peer Wi-Fi Aware device.
 * @return The builder, to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 */

public android.net.wifi.rtt.RangingRequest.Builder addWifiAwarePeer(@android.annotation.NonNull android.net.wifi.aware.PeerHandle peerHandle) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.rtt.RangingRequest RangingRequest} given the current configurations made on the
 * builder.
 */

public android.net.wifi.rtt.RangingRequest build() { throw new RuntimeException("Stub!"); }
}

}

