/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

import android.os.Parcelable;

/**
 * A class representing Wifi Display information for a device.
 *
 * See Wifi Display technical specification v1.0.0, section 5.1.2.
 * See Wifi Display technical specification v2.0.0, section 5.1.12 for Wifi Display R2.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pWfdInfo implements android.os.Parcelable {

/** Default constructor. */

public WifiP2pWfdInfo() { throw new RuntimeException("Stub!"); }

/** Copy constructor. */

public WifiP2pWfdInfo(@android.annotation.Nullable android.net.wifi.p2p.WifiP2pWfdInfo source) { throw new RuntimeException("Stub!"); }

/**
 * Return R1 raw device info, See
 * Wifi Display technical specification v1.0.0, section 5.1.2.
 * Access bit fields by DEVICE_INFO_* constants.
 */

public int getDeviceInfo() { throw new RuntimeException("Stub!"); }

/**
 * Return R2 raw device info, See
 * Wifi Display technical specification v2.0.0, section 5.1.12.
 * Access bit fields by {@link #DEVICE_INFO_DEVICE_TYPE_MASK}.
 */

public int getR2DeviceInfo() { throw new RuntimeException("Stub!"); }

/** Returns true is Wifi Display is enabled, false otherwise. */

public boolean isEnabled() { throw new RuntimeException("Stub!"); }

/** Returns true is Wifi Display R2 is enabled, false otherwise. */

public boolean isR2Supported() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether Wifi Display should be enabled.
 *
 * @param enabled true to enable Wifi Display, false to disable
 */

public void setEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Sets the type of the Wifi Display R2 device.
 * See Wifi Display technical specification v2.0.0, section 5.1.12 for Wifi Display R2.
 * Before calling this API, call {@link WifiManager#isWifiDisplayR2Supported()
 * to know whether Wifi Display R2 is supported or not.
 * If R2 info was filled without Wifi Display R2 support,
 * {@link WifiP2pManager#setWfdInfo(Channel, WifiP2pWfdInfo, ActionListener)
 * would fail.
 *
 * @param deviceType One of {@link #DEVICE_TYPE_WFD_SOURCE}, {@link #DEVICE_TYPE_PRIMARY_SINK},
 * {@link #DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK}
 * @return true if the device type was successfully set, false otherwise
 */

public boolean setR2DeviceType(int deviceType) { throw new RuntimeException("Stub!"); }

/**
 * Get the type of the device.
 * One of {@link #DEVICE_TYPE_WFD_SOURCE}, {@link #DEVICE_TYPE_PRIMARY_SINK},
 * {@link #DEVICE_TYPE_SECONDARY_SINK}, {@link #DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK}
 */

public int getDeviceType() { throw new RuntimeException("Stub!"); }

/**
 * Get the type of the R2 device.
 * One of {@link #DEVICE_TYPE_WFD_SOURCE}, {@link #DEVICE_TYPE_PRIMARY_SINK},
 * or {@link #DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK}
 */

public int getR2DeviceType() { throw new RuntimeException("Stub!"); }

/**
 * Sets the type of the device.
 *
 * @param deviceType One of {@link #DEVICE_TYPE_WFD_SOURCE}, {@link #DEVICE_TYPE_PRIMARY_SINK},
 * {@link #DEVICE_TYPE_SECONDARY_SINK}, {@link #DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK}
 * @return true if the device type was successfully set, false otherwise
 */

public boolean setDeviceType(int deviceType) { throw new RuntimeException("Stub!"); }

/** Returns true if a session is available, false otherwise. */

public boolean isSessionAvailable() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether a session is available.
 *
 * @param enabled true to indicate that a session is available, false otherwise.
 */

public void setSessionAvailable(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * @return true if Content Protection using the HDCP system 2.0/2.1 is supported.
 */

public boolean isContentProtectionSupported() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether Content Protection using the HDCP system 2.0/2.1 is supported.
 *
 * @param enabled true to indicate that Content Protection is supported, false otherwise.
 */

public void setContentProtectionSupported(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if Coupled Sink is supported by WFD Source.
 * See Wifi Display technical specification v1.0.0, section 4.9.
 */

public boolean isCoupledSinkSupportedAtSource() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether Coupled Sink feature is supported by WFD Source.
 * See Wifi Display technical specification v1.0.0, section 4.9.
 *
 * @param enabled true to indicate support for coupled sink, false otherwise.
 */

public void setCoupledSinkSupportAtSource(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if Coupled Sink is supported by WFD Sink.
 * See Wifi Display technical specification v1.0.0, section 4.9.
 */

public boolean isCoupledSinkSupportedAtSink() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether Coupled Sink feature is supported by WFD Sink.
 * See Wifi Display technical specification v1.0.0, section 4.9.
 *
 * @param enabled true to indicate support for coupled sink, false otherwise.
 */

public void setCoupledSinkSupportAtSink(boolean enabled) { throw new RuntimeException("Stub!"); }

/** Returns the TCP port at which the WFD Device listens for RTSP messages. */

public int getControlPort() { throw new RuntimeException("Stub!"); }

/** Sets the TCP port at which the WFD Device listens for RTSP messages. */

public void setControlPort(int port) { throw new RuntimeException("Stub!"); }

/** Sets the maximum average throughput capability of the WFD Device, in megabits/second. */

public void setMaxThroughput(int maxThroughput) { throw new RuntimeException("Stub!"); }

/** Returns the maximum average throughput capability of the WFD Device, in megabits/second. */

public int getMaxThroughput() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.WifiP2pWfdInfo> CREATOR;
static { CREATOR = null; }

/**
 * Bit field for {@link #getDeviceInfo()}, indicate audo is only supported at source.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_AUDIO_ONLY_SUPPORT_AT_SOURCE = 2048; // 0x800

/**
 * Bit field for {@link #getDeviceInfo()}, indicate audio is not supported at primary sink.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_AUDIO_UNSUPPORTED_AT_PRIMARY_SINK = 1024; // 0x400

/**
 * Bit field for {@link #getDeviceInfo()}, indicate the support of Content Protection
 * using the HDCP system 2.0/2.1.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_CONTENT_PROTECTION_SUPPORT = 256; // 0x100

/**
 * Bit field for {@link #getDeviceInfo()}, indicates that coupled sink is supporeted at sink.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_COUPLED_SINK_SUPPORT_AT_SINK = 8; // 0x8

/**
 * Bit field for {@link #getDeviceInfo()}, indicates that coupled sink is supported at source.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_COUPLED_SINK_SUPPORT_AT_SOURCE = 4; // 0x4

/**
 * {@link #getDeviceInfo()} & {@link #DEVICE_INFO_DEVICE_TYPE_MASK} is one of
 * {@link #DEVICE_TYPE_WFD_SOURCE}, {@link #DEVICE_TYPE_PRIMARY_SINK},
 * {@link #DEVICE_TYPE_SECONDARY_SINK} or {@link #DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK}.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement and
 * 5.1.12 WFD R2 Device Information Subelement in Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_DEVICE_TYPE_MASK = 3; // 0x3

/**
 * Bit field for {@link #getDeviceInfo()}, indicate the preferred connectifity for Wifi Display.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 * The value is one of {@link #PREFERRED_CONNECTIVITY_P2P} or
 * {@link #PREFERRED_CONNECTIVITY_TDLS}.
 */

public static final int DEVICE_INFO_PREFERRED_CONNECTIVITY_MASK = 128; // 0x80

/**
 * Bit field for {@link #getDeviceInfo()}, indicates that Wifi Display session is available.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_SESSION_AVAILABLE_MASK = 48; // 0x30

/** Bit field for {@link #getDeviceInfo()}, indicate that TDLS persistent group is intended.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_TDLS_PERSISTENT_GROUP = 4096; // 0x1000

/** Bit field for {@link #getDeviceInfo()}, indicate that the request is for
 * re-invocation of TDLS persistent group.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_TDLS_PERSISTENT_GROUP_REINVOKE = 8192; // 0x2000

/**
 * Bit field for {@link #getDeviceInfo()}, indicate time synchronization
 * using 802.1AS is supported.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_TIME_SYNCHRONIZATION_SUPPORT = 512; // 0x200

/**
 * Bit field for {@link #getDeviceInfo()}, indicates that Wifi Display discovery is supported.
 *
 * The bit definition is listed in 5.1.2 WFD Device Information Subelement in
 * Wifi Display Technical Specification.
 */

public static final int DEVICE_INFO_WFD_SERVICE_DISCOVERY_SUPPORT = 64; // 0x40

/** The device is a primary sink. */

public static final int DEVICE_TYPE_PRIMARY_SINK = 1; // 0x1

/** The device is a secondary sink. This type is only supported by R1. */

public static final int DEVICE_TYPE_SECONDARY_SINK = 2; // 0x2

/** The device is dual-role capable i.e. either a WFD source or a primary sink. */

public static final int DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK = 3; // 0x3

/** The device is a Wifi Display Source. */

public static final int DEVICE_TYPE_WFD_SOURCE = 0; // 0x0

/** Wifi Display (WFD) preferred connectivity is Wifi Direct (P2P). */

public static final int PREFERRED_CONNECTIVITY_P2P = 0; // 0x0

/** Wifi Display (WFD) preferred connectivity is TDLS. */

public static final int PREFERRED_CONNECTIVITY_TDLS = 1; // 0x1
}

