/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

import android.net.NetworkInfo.DetailedState;
import java.util.List;
import android.net.TransportInfo;

/**
 * Describes the state of any Wi-Fi connection that is active or
 * is in the process of being set up.
 *
 * In the connected state, access to location sensitive fields requires
 * the same permissions as {@link android.net.wifi.WifiManager#getScanResults WifiManager#getScanResults}. If such access is not allowed,
 * {@link #getSSID} will return {@link android.net.wifi.WifiManager#UNKNOWN_SSID WifiManager#UNKNOWN_SSID} and
 * {@link #getBSSID} will return {@code "02:00:00:00:00:00"}.
 * {@link #getNetworkId()} will return {@code -1}.
 * {@link #getPasspointFqdn()} will return null.
 * {@link #getPasspointProviderFriendlyName()} will return null.
 * {@link #getInformationElements()} will return null.
 * {@link #getMacAddress()} will return {@code "02:00:00:00:00:00"}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiInfo implements android.net.TransportInfo, android.os.Parcelable {

WifiInfo() { throw new RuntimeException("Stub!"); }

/**
 * Returns the service set identifier (SSID) of the current 802.11 network.
 * <p>
 * If the SSID can be decoded as UTF-8, it will be returned surrounded by double
 * quotation marks. Otherwise, it is returned as a string of hex digits.
 * The SSID may be {@link android.net.wifi.WifiManager#UNKNOWN_SSID WifiManager#UNKNOWN_SSID}, if there is no network currently connected
 * or if the caller has insufficient permissions to access the SSID.
 * </p>
 * <p>
 * Prior to {@link android.os.Build.VERSION_CODES#JELLY_BEAN_MR1}, this method
 * always returned the SSID with no quotes around it.
 * </p>
 *
 * @return the SSID.
 */

public java.lang.String getSSID() { throw new RuntimeException("Stub!"); }

/**
 * Return the basic service set identifier (BSSID) of the current access point.
 * <p>
 * The BSSID may be
 * <lt>{@code null}, if there is no network currently connected.</lt>
 * <lt>{@code "02:00:00:00:00:00"}, if the caller has insufficient permissions to access the
 * BSSID.<lt>
 * </p>
 *
 * @return the BSSID, in the form of a six-byte MAC address: {@code XX:XX:XX:XX:XX:XX}
 */

public java.lang.String getBSSID() { throw new RuntimeException("Stub!"); }

/**
 * Returns the received signal strength indicator of the current 802.11
 * network, in dBm.
 *
 * <p>Use {@link android.net.wifi.WifiManager#calculateSignalLevel} to convert this number into
 * an absolute signal level which can be displayed to a user.
 *
 * @return the RSSI.
 */

public int getRssi() { throw new RuntimeException("Stub!"); }

/**
 * Get connection Wi-Fi standard
 * @return the connection Wi-Fi standard
 */

public int getWifiStandard() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current link speed in {@link #LINK_SPEED_UNITS}.
 * @return the link speed or {@link #LINK_SPEED_UNKNOWN} if link speed is unknown.
 * @see #LINK_SPEED_UNITS
 * @see #LINK_SPEED_UNKNOWN
 */

public int getLinkSpeed() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current transmit link speed in Mbps.
 * @return the Tx link speed or {@link #LINK_SPEED_UNKNOWN} if link speed is unknown.
 * @see #LINK_SPEED_UNKNOWN
 */

public int getTxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum supported transmit link speed in Mbps
 * @return the max supported tx link speed or {@link #LINK_SPEED_UNKNOWN} if link speed is
 * unknown. @see #LINK_SPEED_UNKNOWN
 */

public int getMaxSupportedTxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current receive link speed in Mbps.
 * @return the Rx link speed or {@link #LINK_SPEED_UNKNOWN} if link speed is unknown.
 * @see #LINK_SPEED_UNKNOWN
 */

public int getRxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum supported receive link speed in Mbps
 * @return the max supported Rx link speed or {@link #LINK_SPEED_UNKNOWN} if link speed is
 * unknown. @see #LINK_SPEED_UNKNOWN
 */

public int getMaxSupportedRxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current frequency in {@link #FREQUENCY_UNITS}.
 * @return the frequency.
 * @see #FREQUENCY_UNITS
 */

public int getFrequency() { throw new RuntimeException("Stub!"); }

/**
 * Returns the MAC address used for this connection.
 * @return MAC address of the connection or {@code "02:00:00:00:00:00"} if the caller has
 * insufficient permission.
 */

public java.lang.String getMacAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the Fully Qualified Domain Name of the network if it is a Passpoint network.
 * <p>
 * The FQDN may be
 * <lt>{@code null} if no network currently connected, currently connected network is not
 * passpoint network or the caller has insufficient permissions to access the FQDN.</lt>
 * </p>
 */

@android.annotation.Nullable
public java.lang.String getPasspointFqdn() { throw new RuntimeException("Stub!"); }

/**
 * Returns the Provider Friendly Name of the network if it is a Passpoint network.
 * <p>
 * The Provider Friendly Name may be
 * <lt>{@code null} if no network currently connected, currently connected network is not
 * passpoint network or the caller has insufficient permissions to access the Provider Friendly
 * Name. </lt>
 * </p>
 */

@android.annotation.Nullable
public java.lang.String getPasspointProviderFriendlyName() { throw new RuntimeException("Stub!"); }

/**
 * If this network is provisioned by a carrier, returns subscription Id corresponding to the
 * associated SIM on the device. If this network is not provisioned by a carrier, returns
 * {@link android.telephony.SubscriptionManager#INVALID_SUBSCRIPTION_ID}
 *
 * @see android.net.wifi.WifiNetworkSuggestion.Builder#setSubscriptionId(int)
 * @see android.telephony.SubscriptionInfo#getSubscriptionId()
 */

public int getSubscriptionId() { throw new RuntimeException("Stub!"); }

/**
 * Each configured network has a unique small integer ID, used to identify
 * the network. This method returns the ID for the currently connected network.
 * <p>
 * The networkId may be {@code -1} if there is no currently connected network or if the caller
 * has insufficient permissions to access the network ID.
 * </p>
 *
 * @return the network ID.
 */

public int getNetworkId() { throw new RuntimeException("Stub!"); }

/**
 * Return the detailed state of the supplicant's negotiation with an
 * access point, in the form of a {@link android.net.wifi.SupplicantState SupplicantState} object.
 * @return the current {@link android.net.wifi.SupplicantState SupplicantState}
 */

public android.net.wifi.SupplicantState getSupplicantState() { throw new RuntimeException("Stub!"); }

/**
 * @deprecated Use the methods on {@link android.net.LinkProperties} which can be obtained
 * either via {@link android.net.ConnectivityManager.NetworkCallback#onLinkPropertiesChanged(android.net.Network,android.net.LinkProperties) NetworkCallback#onLinkPropertiesChanged(Network, LinkProperties)} or
 * {@link android.net.ConnectivityManager#getLinkProperties(android.net.Network) ConnectivityManager#getLinkProperties(Network)}.
 */

@Deprecated
public int getIpAddress() { throw new RuntimeException("Stub!"); }

/**
 * @return {@code true} if this network does not broadcast its SSID, so an
 * SSID-specific probe request must be used for scans.
 */

public boolean getHiddenSSID() { throw new RuntimeException("Stub!"); }

/**
 * Map a supplicant state into a fine-grained network connectivity state.
 * @param suppState the supplicant state
 * @return the corresponding {@link android.net.NetworkInfo.DetailedState DetailedState}
 */

public static android.net.NetworkInfo.DetailedState getDetailedStateOf(android.net.wifi.SupplicantState suppState) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface {@hide} */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface {@hide} */

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Get all information elements found in the beacon of the connected bssid.
 * <p>
 * The information elements will be {@code null} if there is no network currently connected or
 * if the caller has insufficient permissions to access the info elements.
 * </p>
 *
 * @return List of information elements {@link android.net.wifi.ScanResult.InformationElement ScanResult.InformationElement} or null.
 */

@android.annotation.Nullable
public java.util.List<android.net.wifi.ScanResult.InformationElement> getInformationElements() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object that) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Create a copy of a {@link android.net.wifi.WifiInfo WifiInfo} with some fields redacted based on the permissions
 * held by the receiving app.
 *
 * @param redactions bitmask of redactions that needs to be performed on this instance.
 * @return Copy of this instance with the necessary redactions.
 */

@android.annotation.NonNull
public android.net.wifi.WifiInfo makeCopy(long redactions) { throw new RuntimeException("Stub!"); }

/**
 * Returns a bitmask of all the applicable redactions (based on the permissions held by the
 * receiving app) to be performed on this TransportInfo.
 *
 * @return bitmask of redactions applicable on this instance.
 */

public long getApplicableRedactions() { throw new RuntimeException("Stub!"); }

/**
 * Returns the security type of the current 802.11 network connection.
 *
 * @return the security type, or {@link #SECURITY_TYPE_UNKNOWN} if not currently connected.
 */

public int getCurrentSecurityType() { throw new RuntimeException("Stub!"); }

/**
 * Frequency in MHz
 */

public static final java.lang.String FREQUENCY_UNITS = "MHz";

/**
 * The unit in which links speeds are expressed.
 */

public static final java.lang.String LINK_SPEED_UNITS = "Mbps";

/**
 * Constant for unknown link speed.
 */

public static final int LINK_SPEED_UNKNOWN = -1; // 0xffffffff

/** Security type for an EAP network. */

public static final int SECURITY_TYPE_EAP = 3; // 0x3

/** Security type for a WPA3-Enterprise network. */

public static final int SECURITY_TYPE_EAP_WPA3_ENTERPRISE = 9; // 0x9

/** Security type for a WPA3-Enterprise in 192-bit security network. */

public static final int SECURITY_TYPE_EAP_WPA3_ENTERPRISE_192_BIT = 5; // 0x5

/** Security type for an open network. */

public static final int SECURITY_TYPE_OPEN = 0; // 0x0

/** Security type for an OSEN network. */

public static final int SECURITY_TYPE_OSEN = 10; // 0xa

/** Security type for an OWE network. */

public static final int SECURITY_TYPE_OWE = 6; // 0x6

/** Security type for a Passpoint R1/R2 network, where TKIP and WEP are not allowed. */

public static final int SECURITY_TYPE_PASSPOINT_R1_R2 = 11; // 0xb

/**
 * Security type for a Passpoint R3 network, where TKIP and WEP are not allowed,
 * and PMF must be set to Required.
 */

public static final int SECURITY_TYPE_PASSPOINT_R3 = 12; // 0xc

/** Security type for a PSK network. */

public static final int SECURITY_TYPE_PSK = 2; // 0x2

/** Security type for an SAE network. */

public static final int SECURITY_TYPE_SAE = 4; // 0x4

/** Unknown security type. */

public static final int SECURITY_TYPE_UNKNOWN = -1; // 0xffffffff

/** Security type for a WAPI Certificate network. */

public static final int SECURITY_TYPE_WAPI_CERT = 8; // 0x8

/** Security type for a WAPI PSK network. */

public static final int SECURITY_TYPE_WAPI_PSK = 7; // 0x7

/** Security type for a WEP network. */

public static final int SECURITY_TYPE_WEP = 1; // 0x1
/** Builder for WifiInfo */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set the SSID, in the form of a raw byte array.
 * @see android.net.wifi.WifiInfo#getSSID()
 */

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setSsid(@android.annotation.NonNull byte[] ssid) { throw new RuntimeException("Stub!"); }

/**
 * Set the BSSID.
 * @see android.net.wifi.WifiInfo#getBSSID()
 */

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setBssid(@android.annotation.NonNull java.lang.String bssid) { throw new RuntimeException("Stub!"); }

/**
 * Set the RSSI, in dBm.
 * @see android.net.wifi.WifiInfo#getRssi()
 */

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setRssi(int rssi) { throw new RuntimeException("Stub!"); }

/**
 * Set the network ID.
 * @see android.net.wifi.WifiInfo#getNetworkId()
 */

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setNetworkId(int networkId) { throw new RuntimeException("Stub!"); }

/**
 * Set the current security type
 * @see android.net.wifi.WifiInfo#getCurrentSecurityType()
 */

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setCurrentSecurityType(int securityType) { throw new RuntimeException("Stub!"); }

/**
 * Build a WifiInfo object.
 */

@android.annotation.NonNull
public android.net.wifi.WifiInfo build() { throw new RuntimeException("Stub!"); }
}

}

