/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * ChildSaProposal represents a proposed configuration to negotiate a Child SA.
 *
 * <p>ChildSaProposal will contain cryptograhic algorithms and key generation materials for the
 * negotiation of a Child SA.
 *
 * <p>User must provide at least one valid ChildSaProposal when they are creating a new Child SA.
 *
 * @see <a href="https://tools.ietf.org/html/rfc7296#section-3.3">RFC 7296, Internet Key Exchange
 *     Protocol Version 2 (IKEv2)</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ChildSaProposal extends android.net.ipsec.ike.SaProposal {

ChildSaProposal() { throw new RuntimeException("Stub!"); }

/**
 * Returns supported encryption algorithms for Child SA proposal negotiation.
 *
 * <p>Some algorithms may not be supported on old devices.
 */

@android.annotation.NonNull
public static java.util.Set<java.lang.Integer> getSupportedEncryptionAlgorithms() { throw new RuntimeException("Stub!"); }

/**
 * Returns supported integrity algorithms for Child SA proposal negotiation.
 *
 * <p>Some algorithms may not be supported on old devices.
 */

@android.annotation.NonNull
public static java.util.Set<java.lang.Integer> getSupportedIntegrityAlgorithms() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }
/**
 * This class is used to incrementally construct a ChildSaProposal. ChildSaProposal instances
 * are immutable once built.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Adds an encryption algorithm with a specific key length to the SA proposal being built.
 *
 * @param algorithm encryption algorithm to add to ChildSaProposal.
 * @param keyLength key length of algorithm. For algorithms that have fixed key length (e.g.
 *     3DES) only {@link android.net.ipsec.ike.SaProposal#KEY_LEN_UNUSED SaProposal#KEY_LEN_UNUSED} is allowed.
 * @return Builder of ChildSaProposal.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.ChildSaProposal.Builder addEncryptionAlgorithm(int algorithm, int keyLength) { throw new RuntimeException("Stub!"); }

/**
 * Adds an integrity algorithm to the SA proposal being built.
 *
 * @param algorithm integrity algorithm to add to ChildSaProposal.
 * @return Builder of ChildSaProposal.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.ChildSaProposal.Builder addIntegrityAlgorithm(int algorithm) { throw new RuntimeException("Stub!"); }

/**
 * Adds a Diffie-Hellman Group to the SA proposal being built.
 *
 * @param dhGroup to add to ChildSaProposal.
 * @return Builder of ChildSaProposal.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.ChildSaProposal.Builder addDhGroup(int dhGroup) { throw new RuntimeException("Stub!"); }

/**
 * Validates and builds the ChildSaProposal.
 *
 * @return the validated ChildSaProposal.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.ChildSaProposal build() { throw new RuntimeException("Stub!"); }
}

}

